/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf75;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    public static final int SMF75RRF = 128;
    public static final int SMF75SUT = 64;
    public static final int SMF75V4 = 16;
    public static final int SMF75ESA = 8;
    public static final int SMF75VXA = 4;
    public static final int SMF75OS = 2;
    public static final int SMF75BFY = 1;

    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Header(byte[] Data2) {
        super(Data2);
    }

    public int smf75len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf75seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf75flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf75rrf() {
        return Util.ConvertFlag(this.data, this.smf75flg(), 128);
    }

    public boolean smf75sut() {
        return Util.ConvertFlag(this.data, this.smf75flg(), 64);
    }

    public boolean smf75v4() {
        return Util.ConvertFlag(this.data, this.smf75flg(), 16);
    }

    public boolean smf75esa() {
        return Util.ConvertFlag(this.data, this.smf75flg(), 8);
    }

    public boolean smf75vxa() {
        return Util.ConvertFlag(this.data, this.smf75flg(), 4);
    }

    public boolean smf75os() {
        return Util.ConvertFlag(this.data, this.smf75flg(), 2);
    }

    public boolean smf75bfy() {
        return Util.ConvertFlag(this.data, this.smf75flg(), 1);
    }

    public int smf75rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf75tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf75tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf75dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf75dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf75sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf75ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf75sty() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf75trn() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf75prs() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf75prl() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf75prn() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf75pss() {
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf75psl() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf75psn() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf75len(0, 2),
        smf75seg(2, 2),
        smf75flg(4, 1),
        smf75rty(5, 1),
        smf75tme(6, 4),
        smf75dte(10, 4),
        smf75sid(14, 4),
        smf75ssi(18, 4),
        smf75sty(22, 2),
        smf75trn(24, 2),
        smf75prs(28, 4),
        smf75prl(32, 2),
        smf75prn(34, 2),
        smf75pss(36, 4),
        smf75psl(40, 2),
        smf75psn(42, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

