/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf75;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf75.ReassemblyArea;
import com.blackhillsoftware.smf.values.BoostClass;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class ProductSection
extends SmfData {
    private ReassemblyArea m_reassemblyArea = null;
    public static final int SMF75CNV = 128;
    public static final int SMF75ISS = 64;
    public static final int SMF75M3R = 32;
    public static final int SMF75ISM = 16;
    public static final int SMF75RCL = 8;
    public static final int SMF75RCH = 4;
    public static final int SMF75AltVM = 2;
    public static final int SMF75IIP = 64;
    public static final int SMF75EED = 32;
    public static final int SMF75BOO = 7;
    public static final int SMF75QES = 128;
    public static final int SMF75CNE = 64;
    public static final int SMF75DRC = 32;
    public static final int SMF75EME = 16;
    public static final int SMF75PRI = 8;
    public static final int SMF75PRP = 4;
    public static final int SMF75PED = 2;
    public static final int SMF75PE2 = 1;

    private ProductSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ReassemblyArea reassemblyArea() {
        if (this.m_reassemblyArea == null && this.smf75ran() == 1) {
            this.m_reassemblyArea = ReassemblyArea.create(this.data, this.smf75rao(), this.smf75ral());
        }
        return this.m_reassemblyArea;
    }

    public int smf75mfv() {
        return Util.ConvertPacked2(this.data, 0);
    }

    public String smf75prd() {
        return Util.ConvertEbcdic(this.data, 2, 8);
    }

    public LocalTime smf75ist() {
        return Util.Packed_HHMMSS(this.data, 10);
    }

    public int smf75istRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public LocalDate smf75dat() {
        return Util.SMFDate(this.data, 14);
    }

    public int smf75datRawValue() {
        return Util.ConvertPacked4(this.data, 14);
    }

    public Duration smf75int() {
        return Util.Packed_MMSSTTT(this.data, 18);
    }

    public double smf75intSeconds() {
        return Util.ToSeconds(this.smf75int());
    }

    public int smf75intRawValue() {
        return Util.ConvertPacked4(this.data, 18);
    }

    public int smf75mfl() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long smf75sam() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int smf75rv2() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf75fla() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public boolean smf75cnv() {
        return Util.ConvertFlag(this.data, this.smf75fla(), 128, Field.smf75fla.length, 0);
    }

    public boolean smf75iss() {
        return Util.ConvertFlag(this.data, this.smf75fla(), 64, Field.smf75fla.length, 0);
    }

    public boolean smf75m3r() {
        return Util.ConvertFlag(this.data, this.smf75fla(), 32, Field.smf75fla.length, 0);
    }

    public boolean smf75ism() {
        return Util.ConvertFlag(this.data, this.smf75fla(), 16, Field.smf75fla.length, 0);
    }

    public boolean smf75rcl() {
        return Util.ConvertFlag(this.data, this.smf75fla(), 8, Field.smf75fla.length, 0);
    }

    public boolean smf75rch() {
        return Util.ConvertFlag(this.data, this.smf75fla(), 4, Field.smf75fla.length, 0);
    }

    public boolean smf75altVm() {
        return Util.ConvertFlag(this.data, this.smf75fla(), 2, Field.smf75fla.length, 0);
    }

    public boolean smf75iip() {
        return Util.ConvertFlag(this.data, this.smf75fla(), 64, Field.smf75fla.length, 1);
    }

    public boolean smf75eed() {
        return Util.ConvertFlag(this.data, this.smf75fla(), 32, Field.smf75fla.length, 1);
    }

    public BoostClass boostClass() {
        if (this.smf75iip() || this.smf75eed()) {
            return BoostClass.from(this.smf75fla() & 7);
        }
        return null;
    }

    public String smf75rls() {
        return Util.ConvertEbcdic(this.data, 32, 4);
    }

    public Duration smf75cyc() {
        return Util.Packed_MMSSTTT(this.data, 36);
    }

    public double smf75cycSeconds() {
        return Util.ToSeconds(this.smf75cyc());
    }

    public int smf75cycRawValue() {
        return Util.ConvertPacked4(this.data, 36);
    }

    public String smf75mvs() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public int smf75iml() {
        return Util.ConvertUnsignedBinary1(this.data, 48);
    }

    public int smf75prf() {
        return Util.ConvertUnsignedBinary1(this.data, 49);
    }

    public boolean smf75qes() {
        return Util.ConvertFlag(this.data, this.smf75prf(), 128);
    }

    public boolean smf75cne() {
        return Util.ConvertFlag(this.data, this.smf75prf(), 64);
    }

    public boolean smf75drc() {
        return Util.ConvertFlag(this.data, this.smf75prf(), 32);
    }

    public boolean smf75eme() {
        return Util.ConvertFlag(this.data, this.smf75prf(), 16);
    }

    public boolean smf75pri() {
        return Util.ConvertFlag(this.data, this.smf75prf(), 8);
    }

    public boolean smf75prp() {
        return Util.ConvertFlag(this.data, this.smf75prf(), 4);
    }

    public boolean smf75ped() {
        return Util.ConvertFlag(this.data, this.smf75prf(), 2);
    }

    public boolean smf75pe2() {
        return Util.ConvertFlag(this.data, this.smf75prf(), 1);
    }

    public int smf75ptn() {
        return Util.ConvertUnsignedBinary1(this.data, 50);
    }

    public int smf75srl() {
        return Util.ConvertUnsignedBinary1(this.data, 51);
    }

    public ZonedDateTime smf75iet() {
        return Util.Binary8xStckTime(this.data, 52);
    }

    public BigInteger smf75ietRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 52);
    }

    public ZoneOffset smf75lgo() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 60);
    }

    public long smf75lgoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 60);
    }

    public int smf75rao() {
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf75ral() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf75ran() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public Duration smf75oil() {
        return Util.Binary2Seconds(this.data, 76);
    }

    public double smf75oilSeconds() {
        return Util.ToSeconds(this.smf75oil());
    }

    public int smf75oilRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public Duration smf75syn() {
        return Util.Binary2Seconds(this.data, 78);
    }

    public double smf75synSeconds() {
        return Util.ToSeconds(this.smf75syn());
    }

    public int smf75synRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public ZonedDateTime smf75gie() {
        return Util.Binary8xStckTime(this.data, 80);
    }

    public BigInteger smf75gieRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public String smf75xnm() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public String smf75snm() {
        return Util.ConvertEbcdic(this.data, 96, 8);
    }

    public static ProductSection create(byte[] Data2, int offset, int length) {
        return new ProductSection(Data2, offset, length);
    }

    static enum Field {
        smf75mfv(0, 2),
        smf75prd(2, 8),
        smf75ist(10, 4),
        smf75dat(14, 4),
        smf75int(18, 4),
        smf75mfl(22, 2),
        smf75sam(24, 4),
        smf75rv2(28, 2),
        smf75fla(30, 2),
        smf75rls(32, 4),
        smf75cyc(36, 4),
        smf75mvs(40, 8),
        smf75iml(48, 1),
        smf75prf(49, 1),
        smf75ptn(50, 1),
        smf75srl(51, 1),
        smf75iet(52, 8),
        smf75lgo(60, 8),
        smf75rao(68, 4),
        smf75ral(72, 2),
        smf75ran(74, 2),
        smf75oil(76, 2),
        smf75syn(78, 2),
        smf75gie(80, 8),
        smf75xnm(88, 8),
        smf75snm(96, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

