/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf76;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    public static final int SMF76RRF = 128;
    public static final int SMF76SUT = 64;
    public static final int SMF76V4 = 16;
    public static final int SMF76ESA = 8;
    public static final int SMF76VXA = 4;
    public static final int SMF76OS = 2;
    public static final int SMF76BFY = 1;

    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Header(byte[] Data2) {
        super(Data2);
    }

    public int smf76len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf76seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf76flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf76rrf() {
        return Util.ConvertFlag(this.data, this.smf76flg(), 128);
    }

    public boolean smf76sut() {
        return Util.ConvertFlag(this.data, this.smf76flg(), 64);
    }

    public boolean smf76v4() {
        return Util.ConvertFlag(this.data, this.smf76flg(), 16);
    }

    public boolean smf76esa() {
        return Util.ConvertFlag(this.data, this.smf76flg(), 8);
    }

    public boolean smf76vxa() {
        return Util.ConvertFlag(this.data, this.smf76flg(), 4);
    }

    public boolean smf76os() {
        return Util.ConvertFlag(this.data, this.smf76flg(), 2);
    }

    public boolean smf76bfy() {
        return Util.ConvertFlag(this.data, this.smf76flg(), 1);
    }

    public int smf76rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf76tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf76tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf76dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf76dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf76sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf76ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf76sty() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf76trn() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf76prs() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf76prl() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf76prn() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf76tcs() {
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf76tcl() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf76tcn() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf76tds() {
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf76tdl() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf76tdn() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf76vfs() {
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf76vfl() {
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf76vfn() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf76len(0, 2),
        smf76seg(2, 2),
        smf76flg(4, 1),
        smf76rty(5, 1),
        smf76tme(6, 4),
        smf76dte(10, 4),
        smf76sid(14, 4),
        smf76ssi(18, 4),
        smf76sty(22, 2),
        smf76trn(24, 2),
        smf76prs(28, 4),
        smf76prl(32, 2),
        smf76prn(34, 2),
        smf76tcs(36, 4),
        smf76tcl(40, 2),
        smf76tcn(42, 2),
        smf76tds(44, 4),
        smf76tdl(48, 2),
        smf76tdn(50, 2),
        smf76vfs(52, 4),
        smf76vfl(56, 2),
        smf76vfn(58, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

