/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf76;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf76.ReassemblyArea;
import com.blackhillsoftware.smf.values.BoostClass;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class ProductSection
extends SmfData {
    private ReassemblyArea m_reassemblyArea = null;
    public static final int SMF76CNV = 128;
    public static final int SMF76ISS = 64;
    public static final int SMF76M3R = 32;
    public static final int SMF76ISM = 16;
    public static final int SMF76RCL = 8;
    public static final int SMF76RCH = 4;
    public static final int SMF76AltVM = 2;
    public static final int SMF76IIP = 64;
    public static final int SMF76EED = 32;
    public static final int SMF76BOO = 7;
    public static final int SMF76QES = 128;
    public static final int SMF76CNE = 64;
    public static final int SMF76DRC = 32;
    public static final int SMF76EME = 16;
    public static final int SMF76PRI = 8;
    public static final int SMF76PRP = 4;
    public static final int SMF76PED = 2;
    public static final int SMF76PE2 = 1;

    private ProductSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ReassemblyArea reassemblyArea() {
        if (this.m_reassemblyArea == null && this.smf76ran() == 1) {
            this.m_reassemblyArea = ReassemblyArea.create(this.data, this.smf76rao(), this.smf76ral());
        }
        return this.m_reassemblyArea;
    }

    public int smf76mfv() {
        return Util.ConvertPacked2(this.data, 0);
    }

    public String smf76prd() {
        return Util.ConvertEbcdic(this.data, 2, 8);
    }

    public LocalTime smf76ist() {
        return Util.Packed_HHMMSS(this.data, 10);
    }

    public int smf76istRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public LocalDate smf76dat() {
        return Util.SMFDate(this.data, 14);
    }

    public int smf76datRawValue() {
        return Util.ConvertPacked4(this.data, 14);
    }

    public Duration smf76int() {
        return Util.Packed_MMSSTTT(this.data, 18);
    }

    public double smf76intSeconds() {
        return Util.ToSeconds(this.smf76int());
    }

    public int smf76intRawValue() {
        return Util.ConvertPacked4(this.data, 18);
    }

    public int smf76mfl() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long smf76sam() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int smf76rv2() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf76fla() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public boolean smf76cnv() {
        return Util.ConvertFlag(this.data, this.smf76fla(), 128, Field.smf76fla.length, 0);
    }

    public boolean smf76iss() {
        return Util.ConvertFlag(this.data, this.smf76fla(), 64, Field.smf76fla.length, 0);
    }

    public boolean smf76m3r() {
        return Util.ConvertFlag(this.data, this.smf76fla(), 32, Field.smf76fla.length, 0);
    }

    public boolean smf76ism() {
        return Util.ConvertFlag(this.data, this.smf76fla(), 16, Field.smf76fla.length, 0);
    }

    public boolean smf76rcl() {
        return Util.ConvertFlag(this.data, this.smf76fla(), 8, Field.smf76fla.length, 0);
    }

    public boolean smf76rch() {
        return Util.ConvertFlag(this.data, this.smf76fla(), 4, Field.smf76fla.length, 0);
    }

    public boolean smf76altVm() {
        return Util.ConvertFlag(this.data, this.smf76fla(), 2, Field.smf76fla.length, 0);
    }

    public boolean smf76iip() {
        return Util.ConvertFlag(this.data, this.smf76fla(), 64, Field.smf76fla.length, 1);
    }

    public boolean smf76eed() {
        return Util.ConvertFlag(this.data, this.smf76fla(), 32, Field.smf76fla.length, 1);
    }

    public BoostClass boostClass() {
        if (this.smf76iip() || this.smf76eed()) {
            return BoostClass.from(this.smf76fla() & 7);
        }
        return null;
    }

    public String smf76rls() {
        return Util.ConvertEbcdic(this.data, 32, 4);
    }

    public Duration smf76cyc() {
        return Util.Packed_MMSSTTT(this.data, 36);
    }

    public double smf76cycSeconds() {
        return Util.ToSeconds(this.smf76cyc());
    }

    public int smf76cycRawValue() {
        return Util.ConvertPacked4(this.data, 36);
    }

    public String smf76mvs() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public int smf76iml() {
        return Util.ConvertUnsignedBinary1(this.data, 48);
    }

    public int smf76prf() {
        return Util.ConvertUnsignedBinary1(this.data, 49);
    }

    public boolean smf76qes() {
        return Util.ConvertFlag(this.data, this.smf76prf(), 128);
    }

    public boolean smf76cne() {
        return Util.ConvertFlag(this.data, this.smf76prf(), 64);
    }

    public boolean smf76drc() {
        return Util.ConvertFlag(this.data, this.smf76prf(), 32);
    }

    public boolean smf76eme() {
        return Util.ConvertFlag(this.data, this.smf76prf(), 16);
    }

    public boolean smf76pri() {
        return Util.ConvertFlag(this.data, this.smf76prf(), 8);
    }

    public boolean smf76prp() {
        return Util.ConvertFlag(this.data, this.smf76prf(), 4);
    }

    public boolean smf76ped() {
        return Util.ConvertFlag(this.data, this.smf76prf(), 2);
    }

    public boolean smf76pe2() {
        return Util.ConvertFlag(this.data, this.smf76prf(), 1);
    }

    public int smf76ptn() {
        return Util.ConvertUnsignedBinary1(this.data, 50);
    }

    public int smf76srl() {
        return Util.ConvertUnsignedBinary1(this.data, 51);
    }

    public ZonedDateTime smf76iet() {
        return Util.Binary8xStckTime(this.data, 52);
    }

    public BigInteger smf76ietRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 52);
    }

    public ZoneOffset smf76lgo() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 60);
    }

    public long smf76lgoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 60);
    }

    public int smf76rao() {
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf76ral() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf76ran() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public Duration smf76oil() {
        return Util.Binary2Seconds(this.data, 76);
    }

    public double smf76oilSeconds() {
        return Util.ToSeconds(this.smf76oil());
    }

    public int smf76oilRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public Duration smf76syn() {
        return Util.Binary2Seconds(this.data, 78);
    }

    public double smf76synSeconds() {
        return Util.ToSeconds(this.smf76syn());
    }

    public int smf76synRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public ZonedDateTime smf76gie() {
        return Util.Binary8xStckTime(this.data, 80);
    }

    public BigInteger smf76gieRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public String smf76xnm() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public String smf76snm() {
        return Util.ConvertEbcdic(this.data, 96, 8);
    }

    public static ProductSection create(byte[] Data2, int offset, int length) {
        return new ProductSection(Data2, offset, length);
    }

    static enum Field {
        smf76mfv(0, 2),
        smf76prd(2, 8),
        smf76ist(10, 4),
        smf76dat(14, 4),
        smf76int(18, 4),
        smf76mfl(22, 2),
        smf76sam(24, 4),
        smf76rv2(28, 2),
        smf76fla(30, 2),
        smf76rls(32, 4),
        smf76cyc(36, 4),
        smf76mvs(40, 8),
        smf76iml(48, 1),
        smf76prf(49, 1),
        smf76ptn(50, 1),
        smf76srl(51, 1),
        smf76iet(52, 8),
        smf76lgo(60, 8),
        smf76rao(68, 4),
        smf76ral(72, 2),
        smf76ran(74, 2),
        smf76oil(76, 2),
        smf76syn(78, 2),
        smf76gie(80, 8),
        smf76xnm(88, 8),
        smf76snm(96, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

