/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf76;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.smf76.Header;
import com.blackhillsoftware.smf.smf76.ProductSection;

public final class Smf76Record
extends SmfRecord {
    private static final CreateSection<ProductSection> buildProductSection = new CreateSection<ProductSection>(){

        @Override
        public ProductSection createSection(byte[] data, int offset, int length) {
            return ProductSection.create(data, offset, length);
        }
    };
    private static final int TRIPLETLENGTH = 8;
    private Header m_header = null;
    private ProductSection m_productSection = null;

    public Smf76Record(byte[] data) {
        super(data);
        if (this.recordType() != 76) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf76Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 76) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf76Record from(SmfRecord record) {
        return new Smf76Record(record);
    }

    public static Smf76Record from(byte[] data) {
        return new Smf76Record(data);
    }

    public Header header() {
        if (this.m_header == null) {
            Header tempHeader = new Header(this.data);
            this.m_header = Header.create(this.data, 0, Header.Field.smf76prs.offset() + tempHeader.smf76trn() * 8);
        }
        return this.m_header;
    }

    public ProductSection productSection() {
        if (this.m_productSection == null) {
            Triplet t = Triplets.ProductSection.getTriplet(this.header());
            this.m_productSection = buildProductSection.createSection(this.data, t.getOffset(), t.getLength());
        }
        return this.m_productSection;
    }

    private static enum Triplets {
        ProductSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf76prs(), header.smf76prl(), header.smf76prn());
            }
        };


        abstract Triplet getTriplet(Header var1);
    }
}

