/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf77;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    public static final int SMF77RRF = 128;
    public static final int SMF77SUT = 64;
    public static final int SMF77V4 = 16;
    public static final int SMF77ESA = 8;
    public static final int SMF77VXA = 4;
    public static final int SMF77OS = 2;
    public static final int SMF77BFY = 1;

    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Header(byte[] Data2) {
        super(Data2);
    }

    public int smf77len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf77seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf77flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf77rrf() {
        return Util.ConvertFlag(this.data, this.smf77flg(), 128);
    }

    public boolean smf77sut() {
        return Util.ConvertFlag(this.data, this.smf77flg(), 64);
    }

    public boolean smf77v4() {
        return Util.ConvertFlag(this.data, this.smf77flg(), 16);
    }

    public boolean smf77esa() {
        return Util.ConvertFlag(this.data, this.smf77flg(), 8);
    }

    public boolean smf77vxa() {
        return Util.ConvertFlag(this.data, this.smf77flg(), 4);
    }

    public boolean smf77os() {
        return Util.ConvertFlag(this.data, this.smf77flg(), 2);
    }

    public boolean smf77bfy() {
        return Util.ConvertFlag(this.data, this.smf77flg(), 1);
    }

    public int smf77rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf77tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf77tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf77dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf77dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf77sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf77ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf77sty() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf77trn() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf77prs() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf77prl() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf77prn() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf77eqs() {
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf77eql() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf77eqn() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf77eds() {
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf77edl() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf77edn() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf77len(0, 2),
        smf77seg(2, 2),
        smf77flg(4, 1),
        smf77rty(5, 1),
        smf77tme(6, 4),
        smf77dte(10, 4),
        smf77sid(14, 4),
        smf77ssi(18, 4),
        smf77sty(22, 2),
        smf77trn(24, 2),
        smf77prs(28, 4),
        smf77prl(32, 2),
        smf77prn(34, 2),
        smf77eqs(36, 4),
        smf77eql(40, 2),
        smf77eqn(42, 2),
        smf77eds(44, 4),
        smf77edl(48, 2),
        smf77edn(50, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

