/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf79;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    public static final int SMF79RRF = 128;
    public static final int SMF79SUT = 64;
    public static final int SMF79V4 = 16;
    public static final int SMF79ESA = 8;
    public static final int SMF79VXA = 4;
    public static final int SMF79OS = 2;
    public static final int SMF79BFY = 1;
    public static final int SMF79ENX = 68;
    public static final int SMF79FNX = 44;

    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Header(byte[] Data2) {
        super(Data2);
    }

    public int smf79len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf79seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf79flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf79rrf() {
        return Util.ConvertFlag(this.data, this.smf79flg(), 128);
    }

    public boolean smf79sut() {
        return Util.ConvertFlag(this.data, this.smf79flg(), 64);
    }

    public boolean smf79v4() {
        return Util.ConvertFlag(this.data, this.smf79flg(), 16);
    }

    public boolean smf79esa() {
        return Util.ConvertFlag(this.data, this.smf79flg(), 8);
    }

    public boolean smf79vxa() {
        return Util.ConvertFlag(this.data, this.smf79flg(), 4);
    }

    public boolean smf79os() {
        return Util.ConvertFlag(this.data, this.smf79flg(), 2);
    }

    public boolean smf79bfy() {
        return Util.ConvertFlag(this.data, this.smf79flg(), 1);
    }

    public int smf79rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf79tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf79tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf79dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf79dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf79sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf79ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf79sty() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf79trn() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf79prs() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf79prl() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf79prn() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf79mcs() {
        if (this.smf79sty() == 15) {
            throw new NotAvailableException("This method is only supported when smf79sty() != 15");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf79mcl() {
        if (this.smf79sty() == 15) {
            throw new NotAvailableException("This method is only supported when smf79sty() != 15");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf79mcn() {
        if (this.smf79sty() == 15) {
            throw new NotAvailableException("This method is only supported when smf79sty() != 15");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf79ass() {
        if (this.smf79sty() == 15) {
            throw new NotAvailableException("This method is only supported when smf79sty() != 15");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf79asl() {
        if (this.smf79sty() == 15) {
            throw new NotAvailableException("This method is only supported when smf79sty() != 15");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf79asn() {
        if (this.smf79sty() == 15) {
            throw new NotAvailableException("This method is only supported when smf79sty() != 15");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf79dcs() {
        if (this.smf79sty() == 15) {
            throw new NotAvailableException("This method is only supported when smf79sty() != 15");
        }
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf79dcl() {
        if (this.smf79sty() == 15) {
            throw new NotAvailableException("This method is only supported when smf79sty() != 15");
        }
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf79dcn() {
        if (this.smf79sty() == 15) {
            throw new NotAvailableException("This method is only supported when smf79sty() != 15");
        }
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf79qss() {
        if (this.smf79sty() == 15) {
            throw new NotAvailableException("This method is only supported when smf79sty() != 15");
        }
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public int smf79qsl() {
        if (this.smf79sty() == 15) {
            throw new NotAvailableException("This method is only supported when smf79sty() != 15");
        }
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf79qsn() {
        if (this.smf79sty() == 15) {
            throw new NotAvailableException("This method is only supported when smf79sty() != 15");
        }
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public int smf79fpo() {
        if (this.smf79sty() != 15) {
            throw new NotAvailableException("This method is only supported when smf79sty() == 15");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf79fpl() {
        if (this.smf79sty() != 15) {
            throw new NotAvailableException("This method is only supported when smf79sty() == 15");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf79fpn() {
        if (this.smf79sty() != 15) {
            throw new NotAvailableException("This method is only supported when smf79sty() == 15");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf79len(0, 2),
        smf79seg(2, 2),
        smf79flg(4, 1),
        smf79rty(5, 1),
        smf79tme(6, 4),
        smf79dte(10, 4),
        smf79sid(14, 4),
        smf79ssi(18, 4),
        smf79sty(22, 2),
        smf79trn(24, 2),
        smf79prs(28, 4),
        smf79prl(32, 2),
        smf79prn(34, 2),
        smf79mcs(36, 4),
        smf79mcl(40, 2),
        smf79mcn(42, 2),
        smf79ass(44, 4),
        smf79asl(48, 2),
        smf79asn(50, 2),
        smf79dcs(52, 4),
        smf79dcl(56, 2),
        smf79dcn(58, 2),
        smf79qss(60, 4),
        smf79qsl(64, 2),
        smf79qsn(66, 2),
        smf79fpo(36, 4),
        smf79fpl(40, 2),
        smf79fpn(42, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

