/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf79;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.smf79.Header;
import com.blackhillsoftware.smf.smf79.ProductSection;

public final class Smf79Record
extends SmfRecord {
    private static final CreateSection<ProductSection> buildProductSection = new CreateSection<ProductSection>(){

        @Override
        public ProductSection createSection(byte[] data, int offset, int length) {
            return ProductSection.create(data, offset, length);
        }
    };
    private static final int TRIPLETLENGTH = 8;
    private Header m_header = null;
    private ProductSection m_productSection = null;

    public Smf79Record(byte[] data) {
        super(data);
        if (this.recordType() != 79) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf79Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 79) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf79Record from(SmfRecord record) {
        return new Smf79Record(record);
    }

    public static Smf79Record from(byte[] data) {
        return new Smf79Record(data);
    }

    public Header header() {
        if (this.m_header == null) {
            Header tempHeader = new Header(this.data);
            this.m_header = Header.create(this.data, 0, Header.Field.smf79prs.offset() + tempHeader.smf79trn() * 8);
        }
        return this.m_header;
    }

    public ProductSection productSection() {
        if (this.m_productSection == null) {
            Triplet t = Triplets.ProductSection.getTriplet(this.header());
            this.m_productSection = buildProductSection.createSection(this.data, t.getOffset(), t.getLength());
        }
        return this.m_productSection;
    }

    private static enum Triplets {
        ProductSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf79prs(), header.smf79prl(), header.smf79prn());
            }
        };


        abstract Triplet getTriplet(Header var1);
    }
}

