/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf89;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class ProductIntersectionData
extends SmfData {
    public static final int SMF89CUC = 128;
    public static final int SMF89CUP = 64;
    public static final int SMF89CFC = 32;
    public static final int SMF89CTC = 16;
    public static final int SMF89CGO = 8;
    public static final int SMF89CHTR = 4;

    private ProductIntersectionData(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf89cnp() {
        return Util.ConvertEbcdic(this.data, 0, 56);
    }

    public String smf89cpo() {
        return Util.ConvertEbcdic(this.data, 0, 16);
    }

    public String smf89cpn() {
        return Util.ConvertEbcdic(this.data, 16, 16);
    }

    public String smf89cpv() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public String smf89cpq() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public String smf89cpi() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public String smf89cni() {
        return Util.ConvertEbcdic(this.data, 56, 56);
    }

    public String smf89ipo() {
        return Util.ConvertEbcdic(this.data, 56, 16);
    }

    public String smf89ipn() {
        return Util.ConvertEbcdic(this.data, 72, 16);
    }

    public String smf89ipv() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public String smf89ipq() {
        return Util.ConvertEbcdic(this.data, 96, 8);
    }

    public String smf89ipi() {
        return Util.ConvertEbcdic(this.data, 104, 8);
    }

    public int smf89cfg() {
        return Util.ConvertUnsignedBinary1(this.data, 112);
    }

    public boolean smf89cuc() {
        return Util.ConvertFlag(this.data, this.smf89cfg(), 128);
    }

    public boolean smf89cup() {
        return Util.ConvertFlag(this.data, this.smf89cfg(), 64);
    }

    public boolean smf89cfc() {
        return Util.ConvertFlag(this.data, this.smf89cfg(), 32);
    }

    public boolean smf89ctc() {
        return Util.ConvertFlag(this.data, this.smf89cfg(), 16);
    }

    public boolean smf89cgo() {
        return Util.ConvertFlag(this.data, this.smf89cfg(), 8);
    }

    public boolean smf89chtr() {
        return Util.ConvertFlag(this.data, this.smf89cfg(), 4);
    }

    public Duration smf89cct() {
        return Util.LongFpHex_x100S(this.data, 120);
    }

    public double smf89cctSeconds() {
        return Util.ToSeconds(this.smf89cct());
    }

    public double smf89cctRawValue() {
        return Util.ConvertLongFPHex(this.data, 120);
    }

    public Duration smf89czt() {
        return Util.LongFpHex_x100S(this.data, 128);
    }

    public double smf89cztSeconds() {
        return Util.ToSeconds(this.smf89czt());
    }

    public double smf89cztRawValue() {
        return Util.ConvertLongFPHex(this.data, 128);
    }

    public static ProductIntersectionData create(byte[] Data2, int offset, int length) {
        return new ProductIntersectionData(Data2, offset, length);
    }

    static enum Field {
        smf89cnp(0, 56),
        smf89cpo(0, 16),
        smf89cpn(16, 16),
        smf89cpv(32, 8),
        smf89cpq(40, 8),
        smf89cpi(48, 8),
        smf89cni(56, 56),
        smf89ipo(56, 16),
        smf89ipn(72, 16),
        smf89ipv(88, 8),
        smf89ipq(96, 8),
        smf89ipi(104, 8),
        smf89cfg(112, 1),
        smf89cct(120, 8),
        smf89czt(128, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

