/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf89;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;

public final class ProductSection
extends SmfData {
    public static final int SMF89P1A = 128;
    public static final int SMF89ZNA = 64;
    public static final int SMF89LGA = 32;
    public static final int SMF89SolutionEdition = 16;
    public static final int SMF89_zCBP = 8;

    private ProductSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf89pnm() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public long smf89rvn() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public String smf89osl() {
        return Util.ConvertEbcdic(this.data, 12, 8);
    }

    public LocalTime smf89ist() {
        return Util.Binary4x100STime(this.data, 20);
    }

    public long smf89istRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public LocalDate smf89isd() {
        return Util.SMFDate(this.data, 24);
    }

    public int smf89isdRawValue() {
        return Util.ConvertPacked4(this.data, 24);
    }

    public LocalTime smf89iet() {
        return Util.Binary4x100STime(this.data, 28);
    }

    public long smf89ietRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public LocalDate smf89ied() {
        return Util.SMFDate(this.data, 32);
    }

    public int smf89iedRawValue() {
        return Util.ConvertPacked4(this.data, 32);
    }

    public int smf89pfl() {
        return Util.ConvertUnsignedBinary1(this.data, 36);
    }

    public boolean smf89p1a() {
        return Util.ConvertFlag(this.data, this.smf89pfl(), 128);
    }

    public boolean smf89zna() {
        return Util.ConvertFlag(this.data, this.smf89pfl(), 64);
    }

    public boolean smf89lga() {
        return Util.ConvertFlag(this.data, this.smf89pfl(), 32);
    }

    public boolean smf89solutionEdition() {
        return Util.ConvertFlag(this.data, this.smf89pfl(), 16);
    }

    public boolean smf89Zcbp() {
        return Util.ConvertFlag(this.data, this.smf89pfl(), 8);
    }

    public String smf89cr() {
        return Util.ConvertEbcdic(this.data, 37, 1);
    }

    public int smf89zep() {
        return Util.ConvertUnsignedBinary1(this.data, 38);
    }

    public ZoneOffset smf89hof() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 40);
    }

    public long smf89hofRawValue() {
        return Util.ConvertSignedBinary8(this.data, 40);
    }

    public ZoneOffset smf89dto() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 48);
    }

    public long smf89dtoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 48);
    }

    public int smf89CoreModeCp() {
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    @Deprecated
    public int smf89CoremodeCp() {
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf89CoreModeZcbp() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    @Deprecated
    public int smf89CoremodeZcbp() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf89CoreModeZaap() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    @Deprecated
    public int smf89CoremodeZaap() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf89CoreModeZiip() {
        return Util.ConvertUnsignedBinary2(this.data, 60);
    }

    @Deprecated
    public int smf89CoremodeZiip() {
        return Util.ConvertUnsignedBinary2(this.data, 60);
    }

    public static ProductSection create(byte[] Data2, int offset, int length) {
        return new ProductSection(Data2, offset, length);
    }

    static enum Field {
        smf89pnm(0, 8),
        smf89rvn(8, 4),
        smf89osl(12, 8),
        smf89ist(20, 4),
        smf89isd(24, 4),
        smf89iet(28, 4),
        smf89ied(32, 4),
        smf89pfl(36, 1),
        smf89cr(37, 1),
        smf89zep(38, 1),
        smf89hof(40, 8),
        smf89dto(48, 8),
        smf89CoreModeCp(56, 2),
        smf89CoreModeZcbp(58, 2),
        smf89CoreModeZaap(58, 2),
        smf89CoreModeZiip(60, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

