/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf9;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    public static final int SMFRCD9 = 0;

    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf9len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf9seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf9flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf9rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf9tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf9tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf9dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf9dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf9sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public int smf9lenn() {
        return Util.ConvertUnsignedBinary2(this.data, 18);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf9len(0, 2),
        smf9seg(2, 2),
        smf9flg(4, 1),
        smf9rty(5, 1),
        smf9tme(6, 4),
        smf9dte(10, 4),
        smf9sid(14, 4),
        smf9lenn(18, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

