/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.security.Token;
import com.blackhillsoftware.smf.smf90.DynamicApfAction;
import com.blackhillsoftware.smf.smf90.DynamicApfSource;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class DynamicApfSection
extends SmfData {
    public static final int SMF90T37_ALREADYASNEEDED = 1;
    public static final int SMF90T37_LEN = 176;

    private DynamicApfSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public DynamicApfAction smf90t37function() {
        int value = Util.ConvertUnsignedBinary1(this.data, 0);
        return DynamicApfAction.from(value);
    }

    public int smf90t37functionRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public int smf90t37flags() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public DynamicApfSource dynamicApfSource() {
        return DynamicApfSource.from(Util.ConvertUnsignedBinary1(this.data, 1) & 0xFE);
    }

    public boolean smf90T37alreadyAsNeeded() {
        return Util.ConvertFlag(this.data, this.smf90t37flags(), 1);
    }

    public String smf90t37parmMemSuffix() {
        return Util.ConvertEbcdic(this.data, 2, 2);
    }

    public String smf90t37dsname() {
        return Util.ConvertEbcdic(this.data, 4, 44);
    }

    public String smf90t37volume() {
        return Util.ConvertEbcdic(this.data, 48, 6);
    }

    public ZonedDateTime smf90t37timestamp() {
        return Util.Binary8xStckTime(this.data, 56);
    }

    public BigInteger smf90t37timestampRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public String smf90t37jobname() {
        return Util.ConvertEbcdic(this.data, 64, 8);
    }

    public String smf90t37chkey() {
        return Util.ConvertEbcdic(this.data, 72, 8);
    }

    public long smf90t37consid() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public Token smf90t37utoken() {
        return Token.create(this.data, 88, 80);
    }

    public String smf90t37utokenUserid() {
        return Util.ConvertEbcdic(this.data, 152, 8);
    }

    public String smf90t37consname() {
        return Util.ConvertEbcdic(this.data, 168, 8);
    }

    public static DynamicApfSection create(byte[] Data2, int offset, int length) {
        return new DynamicApfSection(Data2, offset, length);
    }

    static enum Field {
        smf90t37function(0, 1),
        smf90t37flags(1, 1),
        smf90t37parmMemSuffix(2, 2),
        smf90t37dsname(4, 44),
        smf90t37volume(48, 6),
        smf90t37timestamp(56, 8),
        smf90t37jobname(64, 8),
        smf90t37chkey(72, 8),
        smf90t37consid(80, 4),
        smf90t37utoken(88, 80),
        smf90t37utokenUserid(152, 8),
        smf90t37consname(168, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

