/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.security.Token;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class IefopzConfigurationSection
extends SmfData {
    public static final int SMF90T38_SET_IEFOPZ = 128;
    public static final int SMF90T38_MSI = 64;
    public static final int SMF90T38_MORE = 2;
    public static final int SMF90T38_CONTINUATION = 1;

    private IefopzConfigurationSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf90t38flags() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean smf90t38SetIefopz() {
        return Util.ConvertFlag(this.data, this.smf90t38flags(), 128);
    }

    public boolean smf90t38Msi() {
        return Util.ConvertFlag(this.data, this.smf90t38flags(), 64);
    }

    public boolean smf90t38More() {
        return Util.ConvertFlag(this.data, this.smf90t38flags(), 2);
    }

    public boolean smf90t38Continuation() {
        return Util.ConvertFlag(this.data, this.smf90t38flags(), 1);
    }

    public int smf90t38ContinuationNumber() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf90t38MaxArch() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public String smf90t38MaxArchIefopzXXSuffix() {
        return Util.ConvertEbcdic(this.data, 6, 2);
    }

    public long smf90t38Consid() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public String smf90t38ConsName() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public ZonedDateTime smf90t38Timestamp() {
        return Util.Binary8xStckTime(this.data, 24);
    }

    public BigInteger smf90t38TimestampRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public String smf90t38Jobname() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public String smf90t38Chkey() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public Token smf90t38Utoken() {
        return Token.create(this.data, 48, 80);
    }

    public String smf90t38UtokenUserid() {
        return Util.ConvertEbcdic(this.data, 112, 8);
    }

    public int smf90t38NumOldnew() {
        return Util.ConvertSignedBinary4(this.data, 128);
    }

    public int smf90t38OldnewOffset() {
        return Util.ConvertSignedBinary4(this.data, 132);
    }

    public int smf90t38OldnewLen() {
        return Util.ConvertSignedBinary4(this.data, 136);
    }

    public int smf90t38NumDDJobname() {
        return Util.ConvertSignedBinary4(this.data, 140);
    }

    public int smf90t38DDJobnameOffset() {
        return Util.ConvertSignedBinary4(this.data, 144);
    }

    public int smf90t38DDJobnameLen() {
        return Util.ConvertSignedBinary4(this.data, 148);
    }

    public static IefopzConfigurationSection create(byte[] Data2, int offset, int length) {
        return new IefopzConfigurationSection(Data2, offset, length);
    }

    static enum Field {
        smf90t38flags(0, 1),
        smf90t38ContinuationNumber(2, 2),
        smf90t38MaxArch(4, 2),
        smf90t38MaxArchIefopzXXSuffix(6, 2),
        smf90t38Consid(12, 4),
        smf90t38ConsName(16, 8),
        smf90t38Timestamp(24, 8),
        smf90t38Jobname(32, 8),
        smf90t38Chkey(40, 8),
        smf90t38Utoken(48, 80),
        smf90t38UtokenUserid(112, 8),
        smf90t38NumOldnew(128, 4),
        smf90t38OldnewOffset(132, 4),
        smf90t38OldnewLen(136, 4),
        smf90t38NumDDJobname(140, 4),
        smf90t38DDJobnameOffset(144, 4),
        smf90t38DDJobnameLen(148, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

