/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;

public final class Lpmea
extends SmfData {
    public static final int LPMEAFIXED = 128;
    public static final int LPMEAPAGEPROTPAGE = 64;
    public static final int LPMEASTORAGEOWNERSYSTEM = 32;
    public static final int LPMEASVC = 128;
    public static final int LPMEAESVC = 64;
    public static final int LPMEASUCCESS = 128;
    public static final int LPMEAMODPROB = 64;
    public static final int LPMEAMODPROBABENDINFO = 32;
    public static final int LPMEAMODPROBRETURNCODEINFO = 16;
    public static final int LPMEARMODE64 = 1;
    public static final int LPMEAENTRYPOINTADDRBIT0 = 128;
    public static final int LPMEAENTRYPOINTADDRBIT31 = 1;
    public static final int LPMEAMODPROBNOTFOUND = 1;
    public static final int LPMEAMODPROBNOTAUTH = 2;
    public static final int LPMEAMODPROBDIRECTORY = 3;
    public static final int LPMEAMODPROBFETCH = 4;
    public static final int LPMEAMODPROBPAGEPROT = 6;
    public static final int LPMEAMODPROBTOOMANYEXTENTS = 7;
    public static final int LPMEAMODPROBNOTEXECUTABLE = 8;
    public static final int LPMEAMODPROBDESERVDESL = 10;
    public static final int LPMEAMODPROBDUPLICATE = 11;
    public static final int LPMEAMODPROBAMODE64NOTZARCH = 12;
    public static final int LPMEAMODPROBBPX4LOD = 13;
    public static final int LPMEAMODPROBNOTAPFPROG = 14;
    public static final int LPMEAMODPROBNOTAPFDS = 15;
    public static final int LPMEAMODPROBUNEXPECTEDABEND = 20;
    public static final int LPMEA_LEN = 40;

    private Lpmea(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String lpmeaName() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public int lpmeaInputFlags0() {
        return Util.ConvertUnsignedBinary1(this.data, 8);
    }

    public boolean lpmeaFixed() {
        return Util.ConvertFlag(this.data, this.lpmeaInputFlags0(), 128);
    }

    public boolean lpmeaPageProtPage() {
        return Util.ConvertFlag(this.data, this.lpmeaInputFlags0(), 64);
    }

    public boolean lpmeaStorageOwnerSystem() {
        return Util.ConvertFlag(this.data, this.lpmeaInputFlags0(), 32);
    }

    public int lpmeaInputFlags1() {
        return Util.ConvertUnsignedBinary1(this.data, 9);
    }

    public boolean lpmeaSvc() {
        return Util.ConvertFlag(this.data, this.lpmeaInputFlags1(), 128);
    }

    public boolean lpmeaESvc() {
        return Util.ConvertFlag(this.data, this.lpmeaInputFlags1(), 64);
    }

    public int lpmeaOutputFlags0() {
        return Util.ConvertUnsignedBinary1(this.data, 10);
    }

    public boolean lpmeaSuccess() {
        return Util.ConvertFlag(this.data, this.lpmeaOutputFlags0(), 128);
    }

    public boolean lpmeaModprob() {
        return Util.ConvertFlag(this.data, this.lpmeaOutputFlags0(), 64);
    }

    public boolean lpmeaModprobAbendInfo() {
        return Util.ConvertFlag(this.data, this.lpmeaOutputFlags0(), 32);
    }

    public boolean lpmeaModprobReturnCodeInfo() {
        return Util.ConvertFlag(this.data, this.lpmeaOutputFlags0(), 16);
    }

    public boolean lpmeaMode64() {
        return Util.ConvertFlag(this.data, this.lpmeaOutputFlags0(), 1);
    }

    public int lpmeaModprobFunction() {
        if (!this.lpmeaModprob()) {
            throw new NotAvailableException("This method is only supported when lpmeaModprob() == true");
        }
        return Util.ConvertUnsignedBinary1(this.data, 11);
    }

    public int lpmeaSuccessConcatNum() {
        return Util.ConvertUnsignedBinary1(this.data, 11);
    }

    public BigInteger lpmeaDeleteToken() {
        if (!this.lpmeaSuccess()) {
            throw new NotAvailableException("This method is only supported when lpmeaSuccess() == true");
        }
        return Util.ConvertBigInteger(this.data, 12, 8);
    }

    public long lpmeaEntrypointAddr() {
        if (!this.lpmeaSuccess()) {
            throw new NotAvailableException("This method is only supported when lpmeaSuccess() == true");
        }
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public int lpmeaEntryPointAddrBytes0to2() {
        if (!this.lpmeaSuccess()) {
            throw new NotAvailableException("This method is only supported when lpmeaSuccess() == true");
        }
        return Util.ConvertUnsignedBinary3(this.data, 20);
    }

    public boolean lpmeaEntryPointAddrBit0() {
        return Util.ConvertFlag(this.data, this.lpmeaEntryPointAddrBytes0to2(), 128, Field.lpmeaEntryPointAddrBytes0to2.length, 1);
    }

    public int lpmeaEntryPointAddrByte3() {
        if (!this.lpmeaSuccess()) {
            throw new NotAvailableException("This method is only supported when lpmeaSuccess() == true");
        }
        return Util.ConvertUnsignedBinary1(this.data, 23);
    }

    public boolean lpmeaEntryPointAddrBit31() {
        return Util.ConvertFlag(this.data, this.lpmeaEntryPointAddrByte3(), 1);
    }

    public long lpmeaLoadPointAddr() {
        if (!this.lpmeaSuccess()) {
            throw new NotAvailableException("This method is only supported when lpmeaSuccess() == true");
        }
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long lpmeaModLen() {
        if (!this.lpmeaSuccess()) {
            throw new NotAvailableException("This method is only supported when lpmeaSuccess() == true");
        }
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long lpmeaLoadPointAddr2() {
        if (!this.lpmeaSuccess()) {
            throw new NotAvailableException("This method is only supported when lpmeaSuccess() == true");
        }
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long lpmeaModLen2() {
        if (!this.lpmeaSuccess()) {
            throw new NotAvailableException("This method is only supported when lpmeaSuccess() == true");
        }
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long lpmeaRetcode() {
        if (!this.lpmeaModprobReturnCodeInfo()) {
            throw new NotAvailableException("This method is only supported when lpmeaModprobReturnCodeInfo() == true");
        }
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long lpmeaRsncode() {
        if (!this.lpmeaModprobReturnCodeInfo()) {
            throw new NotAvailableException("This method is only supported when lpmeaModprobReturnCodeInfo() == true");
        }
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long lpmeaAbendCode() {
        if (!this.lpmeaModprobAbendInfo()) {
            throw new NotAvailableException("This method is only supported when lpmeaModprobAbendInfo() == true");
        }
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long lpmeaAbendRsncode() {
        if (!this.lpmeaModprobAbendInfo()) {
            throw new NotAvailableException("This method is only supported when lpmeaModprobAbendInfo() == true");
        }
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public boolean lpmeaModprobNotFound() {
        return Util.ConvertEquateValue(this.data, this.lpmeaModprobFunction(), 1);
    }

    public boolean lpmeaModprobNotAuth() {
        return Util.ConvertEquateValue(this.data, this.lpmeaModprobFunction(), 2);
    }

    public boolean lpmeaModprobDirectory() {
        return Util.ConvertEquateValue(this.data, this.lpmeaModprobFunction(), 3);
    }

    public boolean lpmeaModprobFetch() {
        return Util.ConvertEquateValue(this.data, this.lpmeaModprobFunction(), 4);
    }

    public boolean lpmeaModprobPageProt() {
        return Util.ConvertEquateValue(this.data, this.lpmeaModprobFunction(), 6);
    }

    public boolean lpmeaModprobTooManyExtents() {
        return Util.ConvertEquateValue(this.data, this.lpmeaModprobFunction(), 7);
    }

    public boolean lpmeaModprobNotExecutable() {
        return Util.ConvertEquateValue(this.data, this.lpmeaModprobFunction(), 8);
    }

    public boolean lpmeaModprobDeservdesl() {
        return Util.ConvertEquateValue(this.data, this.lpmeaModprobFunction(), 10);
    }

    public boolean lpmeaModprobDuplicate() {
        return Util.ConvertEquateValue(this.data, this.lpmeaModprobFunction(), 11);
    }

    public boolean lpmeaModprobAmode64NotZArch() {
        return Util.ConvertEquateValue(this.data, this.lpmeaModprobFunction(), 12);
    }

    public boolean lpmeaModprobBpx4lod() {
        return Util.ConvertEquateValue(this.data, this.lpmeaModprobFunction(), 13);
    }

    public boolean lpmeaModprobNotApfProg() {
        return Util.ConvertEquateValue(this.data, this.lpmeaModprobFunction(), 14);
    }

    public boolean lpmeaModprobNotApfDs() {
        return Util.ConvertEquateValue(this.data, this.lpmeaModprobFunction(), 15);
    }

    public boolean lpmeaModprobUnexpectedAbend() {
        return Util.ConvertEquateValue(this.data, this.lpmeaModprobFunction(), 20);
    }

    public static Lpmea create(byte[] Data2, int offset, int length) {
        return new Lpmea(Data2, offset, length);
    }

    static enum Field {
        lpmeaName(0, 8),
        lpmeaInputFlags0(8, 1),
        lpmeaInputFlags1(9, 1),
        lpmeaOutputFlags0(10, 1),
        lpmeaModprobFunction(11, 1),
        lpmeaSuccessConcatNum(11, 1),
        lpmeaDeleteToken(12, 8),
        lpmeaEntrypointAddr(20, 4),
        lpmeaEntryPointAddrBytes0to2(20, 3),
        lpmeaEntryPointAddrByte3(23, 1),
        lpmeaLoadPointAddr(24, 4),
        lpmeaModLen(28, 4),
        lpmeaLoadPointAddr2(32, 4),
        lpmeaModLen2(36, 4),
        lpmeaRetcode(12, 4),
        lpmeaRsncode(16, 4),
        lpmeaAbendCode(12, 4),
        lpmeaAbendRsncode(16, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

