/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.Token;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf90.ValidationFailureReason;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class ValidatedBootAuditEntry
extends SmfData {
    public static final int SMF90T42_A_FoundSig = 128;
    public static final int SMF90T42_A_haveMachLoaderErrors = 32;

    private ValidatedBootAuditEntry(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf90t42AModname() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String smf90t42ADsname() {
        return Util.ConvertEbcdic(this.data, 8, 44);
    }

    public String smf90t42AVolID() {
        return Util.ConvertEbcdic(this.data, 52, 6);
    }

    public ValidationFailureReason smf90t42AFailReason() {
        int value = Util.ConvertUnsignedBinary2(this.data, 58);
        return ValidationFailureReason.from(value);
    }

    public int smf90t42AFailReasonRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf90t42AFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 60);
    }

    public boolean smf90t42AFoundSig() {
        return Util.ConvertFlag(this.data, this.smf90t42AFlags(), 128);
    }

    public boolean smf90t42AHaveMachLoaderErrors() {
        return Util.ConvertFlag(this.data, this.smf90t42AFlags(), 32);
    }

    public long smf90t42ANumFailures() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long smf90t42ADsnNumFailures() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public ZonedDateTime smf90t42ASignTime() {
        return Util.Binary8HiStckeTime(this.data, 72);
    }

    public BigInteger smf90t42ASignTimeRawValue() {
        return Util.ConvertBigInteger(this.data, 72, 8);
    }

    public Token smf90t42ACertFP() {
        if (this.data.length >= 112) {
            return new Token(this.data, 80, 32);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(80) + " Data length: " + Integer.toString(32));
    }

    public Token smf90t42AKeyID() {
        if (!this.smf90t42AFoundSig()) {
            throw new NotAvailableException("This method is only supported when (smf90t42AFoundSig() == true)");
        }
        if (this.data.length >= 132) {
            return new Token(this.data, 112, 20);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(112) + " Data length: " + Integer.toString(20));
    }

    public long smf90t42AMleEd() {
        if (!this.smf90t42AHaveMachLoaderErrors()) {
            throw new NotAvailableException("This method is only supported when (smf90t42AHaveMachLoaderErrors() == true)");
        }
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public int smf90t42AMleIiei() {
        if (!this.smf90t42AHaveMachLoaderErrors()) {
            throw new NotAvailableException("This method is only supported when (smf90t42AHaveMachLoaderErrors() == true)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 116);
    }

    public ZonedDateTime smf90t42AFailTime() {
        return Util.Binary8HiStckeTime(this.data, 132);
    }

    public BigInteger smf90t42AFailTimeRawValue() {
        return Util.ConvertBigInteger(this.data, 132, 8);
    }

    public static ValidatedBootAuditEntry create(byte[] Data2, int offset, int length) {
        return new ValidatedBootAuditEntry(Data2, offset, length);
    }

    static enum Field {
        smf90t42AModname(0, 8),
        smf90t42ADsname(8, 44),
        smf90t42AVolID(52, 6),
        smf90t42AFailReason(58, 2),
        smf90t42AFlags(60, 1),
        smf90t42ANumFailures(64, 4),
        smf90t42ADsnNumFailures(68, 4),
        smf90t42ASignTime(72, 8),
        smf90t42ACertFP(80, 32),
        smf90t42AKeyID(112, 20),
        smf90t42AMleEd(112, 4),
        smf90t42AMleIiei(116, 2),
        smf90t42AFailTime(132, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

