/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.FileType;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class FileClose
extends SmfData {
    public static final int SMF92CNF = 128;
    public static final int SMF92CNS = 64;
    public static final int SMF92CCS = 32;
    public static final int SMF92CFC = 16;
    public static final int SMF92CDR = 8;
    public static final int SMF92CDW = 4;

    private FileClose(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92cto() {
        return Util.Binary8xStckTime(this.data, 0);
    }

    public BigInteger smf92ctoRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public ZonedDateTime smf92ctc() {
        return Util.Binary8xStckTime(this.data, 8);
    }

    public BigInteger smf92ctcRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public FileType smf92cty() {
        return FileType.fromValue(this.smf92ctyRawValue());
    }

    public int smf92ctyRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 16);
    }

    public int smf92cfg() {
        return Util.ConvertUnsignedBinary1(this.data, 17);
    }

    public boolean smf92cnf() {
        return Util.ConvertFlag(this.data, this.smf92cfg(), 128);
    }

    public boolean smf92cns() {
        return Util.ConvertFlag(this.data, this.smf92cfg(), 64);
    }

    public boolean smf92ccs() {
        return Util.ConvertFlag(this.data, this.smf92cfg(), 32);
    }

    public boolean smf92cfc() {
        return Util.ConvertFlag(this.data, this.smf92cfg(), 16);
    }

    public boolean smf92cdr() {
        return Util.ConvertFlag(this.data, this.smf92cfg(), 8);
    }

    public boolean smf92cdw() {
        return Util.ConvertFlag(this.data, this.smf92cfg(), 4);
    }

    public long smf92ctk() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long smf92cin() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long smf92cdn() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long smf92csr() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long smf92csw() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long smf92cdi() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long smf92cir() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long smf92ciw() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long smf92cbr() {
        return Util.ConvertUnsignedBinary8(this.data, 52);
    }

    public BigInteger smf92cbrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 52);
    }

    public long smf92cbw() {
        return Util.ConvertUnsignedBinary8(this.data, 60);
    }

    public BigInteger smf92cbwAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 60);
    }

    public String smf92cpn() {
        if (this.data.length < Field.smf92cpn.offset + Field.smf92cpn.length) {
            return "";
        }
        return Util.ConvertEbcdic(this.data, 68, 64);
    }

    public static FileClose create(byte[] Data2, int offset, int length) {
        return new FileClose(Data2, offset, length);
    }

    static enum Field {
        smf92cto(0, 8),
        smf92ctc(8, 8),
        smf92cty(16, 1),
        smf92cfg(17, 1),
        smf92ctk(20, 4),
        smf92cin(24, 4),
        smf92cdn(28, 4),
        smf92csr(32, 4),
        smf92csw(36, 4),
        smf92cdi(40, 4),
        smf92cir(44, 4),
        smf92ciw(48, 4),
        smf92cbr(52, 8),
        smf92cbw(60, 8),
        smf92cpn(68, 64);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

