/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.FileType;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class FileDeleteRename
extends SmfData {
    public static final int SMF92DREN = 128;

    private FileDeleteRename(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92dft() {
        return Util.Binary8xStckTime(this.data, 0);
    }

    public BigInteger smf92dftRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public FileType smf92dty() {
        return FileType.fromValue(this.smf92dtyRawValue());
    }

    public int smf92dtyRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 8);
    }

    public int smf92dflg() {
        return Util.ConvertUnsignedBinary1(this.data, 9);
    }

    public boolean smf92dren() {
        return Util.ConvertFlag(this.data, this.smf92dflg(), 128);
    }

    public long smf92din() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf92dinp() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smf92ddn() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public String smf92dfs() {
        return Util.ConvertEbcdic(this.data, 24, 44);
    }

    public int smf92dnl() {
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public String smf92dfn() {
        if (this.data.length >= 72 + this.smf92dnl()) {
            return Util.ConvertEbcdic(this.data, 72, this.smf92dnl());
        }
        return null;
    }

    public int smf92dnlr() {
        return Util.ConvertSignedBinary4(this.data, 136);
    }

    public String smf92dfnr() {
        if (this.smf92dren()) {
            return Util.ConvertEbcdic(this.data, 140, this.smf92dnlr());
        }
        return null;
    }

    public static FileDeleteRename create(byte[] Data2, int offset, int length) {
        return new FileDeleteRename(Data2, offset, length);
    }

    static enum Field {
        smf92dft(0, 8),
        smf92dty(8, 1),
        smf92dflg(9, 1),
        smf92din(12, 4),
        smf92dinp(16, 4),
        smf92ddn(20, 4),
        smf92dfs(24, 44),
        smf92dnl(68, 4),
        smf92dfn(72, 0),
        smf92dnlr(136, 4),
        smf92dfnr(140, 0);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

