/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.FileSystemPath;
import com.blackhillsoftware.smf.smf92.FileSystemType;
import com.blackhillsoftware.smf.smf92.MntEntFsMode;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class FileSystemMount
extends SmfData {
    private byte[] parentData;
    public static final int SMF92MAU = 128;
    public static final int SMF92MAS = 64;
    public static final int SMF92MRM = 32;
    public static final int SMF92MLU = 128;
    public static final int SMF92MNU = 64;
    public static final int SMF92MDO = 32;
    public static final int SMF92MSN = 16;

    private FileSystemMount(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
        this.parentData = Data2;
    }

    public ZonedDateTime smf92mtm() {
        return Util.Binary8xStckTime(this.data, 0);
    }

    public BigInteger smf92mtmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public int smf92mpf() {
        return Util.ConvertSignedBinary4(this.data, 8);
    }

    public FileSystemPath fileSystemPathSection() {
        return FileSystemPath.create(this.parentData, this.smf92mpf(), FileSystemPath.smf92ppl(this.parentData, this.smf92mpf()) + FileSystemPath.Field.smf92ppl.length());
    }

    public String smf92ppn() {
        return this.fileSystemPathSection().smf92ppn();
    }

    public FileSystemType smf92mft() {
        return FileSystemType.fromValue(this.smf92mftRawValue());
    }

    public long smf92mftRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public MntEntFsMode smf92mfm() {
        return MntEntFsMode.create(this.data, Field.smf92mfm.offset, Field.smf92mfm.length);
    }

    public long smf92mfmRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smf92mdn() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public String smf92mdd() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public String smf92mtn() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public String smf92mfn() {
        return Util.ConvertEbcdic(this.data, 40, 44);
    }

    public long smf92mbl() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long smf92mst() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger smf92mstAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public long smf92msu() {
        return Util.ConvertUnsignedBinary8(this.data, 96);
    }

    public BigInteger smf92msuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public int smf92mfg() {
        return Util.ConvertUnsignedBinary1(this.data, 104);
    }

    public boolean smf92mau() {
        return Util.ConvertFlag(this.data, this.smf92mfg(), 128);
    }

    public boolean smf92mas() {
        return Util.ConvertFlag(this.data, this.smf92mfg(), 64);
    }

    public boolean smf92mrm() {
        return Util.ConvertFlag(this.data, this.smf92mfg(), 32);
    }

    public int smf92mf2() {
        return Util.ConvertUnsignedBinary1(this.data, 105);
    }

    public boolean smf92mlu() {
        return Util.ConvertFlag(this.data, this.smf92mf2(), 128);
    }

    public boolean smf92mnu() {
        return Util.ConvertFlag(this.data, this.smf92mf2(), 64);
    }

    public boolean smf92mdo() {
        return Util.ConvertFlag(this.data, this.smf92mf2(), 32);
    }

    public boolean smf92msn() {
        return Util.ConvertFlag(this.data, this.smf92mf2(), 16);
    }

    public static FileSystemMount create(byte[] Data2, int offset, int length) {
        return new FileSystemMount(Data2, offset, length);
    }

    static enum Field {
        smf92mtm(0, 8),
        smf92mpf(8, 4),
        smf92mft(12, 4),
        smf92mfm(16, 4),
        smf92mdn(20, 4),
        smf92mdd(24, 8),
        smf92mtn(32, 8),
        smf92mfn(40, 44),
        smf92mbl(84, 4),
        smf92mst(88, 8),
        smf92msu(96, 8),
        smf92mfg(104, 1),
        smf92mf2(105, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

