/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.FileSystemType;
import com.blackhillsoftware.smf.smf92.MntEntFsMode;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class FileSystemUnmountRemount
extends SmfData {
    public static final int SMF92UAU = 128;
    public static final int SMF92UMI = 64;
    public static final int SMF92ULU = 128;
    public static final int SMF92UNU = 64;
    public static final int SMF92UDO = 32;
    public static final int SMF92USN = 16;

    private FileSystemUnmountRemount(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92utm() {
        return Util.Binary8xStckTime(this.data, 0);
    }

    public BigInteger smf92utmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public ZonedDateTime smf92utu() {
        return Util.Binary8xStckTime(this.data, 8);
    }

    public BigInteger smf92utuRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public FileSystemType smf92uft() {
        return FileSystemType.fromValue(this.smf92uftRawValue());
    }

    public long smf92uftRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public MntEntFsMode smf92ufm() {
        return MntEntFsMode.create(this.data, Field.smf92ufm.offset, Field.smf92ufm.length);
    }

    public long smf92ufmRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long smf92udn() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public String smf92udd() {
        return Util.ConvertEbcdic(this.data, 28, 8);
    }

    public String smf92utn() {
        return Util.ConvertEbcdic(this.data, 36, 8);
    }

    public String smf92ufn() {
        return Util.ConvertEbcdic(this.data, 44, 44);
    }

    public long smf92ubl() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long smf92ust() {
        return Util.ConvertUnsignedBinary8(this.data, 92);
    }

    public BigInteger smf92ustAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 92);
    }

    public long smf92usu() {
        return Util.ConvertUnsignedBinary8(this.data, 100);
    }

    public BigInteger smf92usuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 100);
    }

    public long smf92usr() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public long smf92usw() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public long smf92udi() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public long smf92uir() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public long smf92uiw() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public long smf92ubr() {
        return Util.ConvertUnsignedBinary8(this.data, 128);
    }

    public BigInteger smf92ubrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 128);
    }

    public long smf92ubw() {
        return Util.ConvertUnsignedBinary8(this.data, 136);
    }

    public BigInteger smf92ubwAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 136);
    }

    public int smf92ufg() {
        return Util.ConvertUnsignedBinary1(this.data, 144);
    }

    public boolean smf92uau() {
        return Util.ConvertFlag(this.data, this.smf92ufg(), 128);
    }

    public boolean smf92umi() {
        return Util.ConvertFlag(this.data, this.smf92ufg(), 64);
    }

    public int smf92uf2() {
        return Util.ConvertUnsignedBinary1(this.data, 145);
    }

    public boolean smf92ulu() {
        return Util.ConvertFlag(this.data, this.smf92uf2(), 128);
    }

    public boolean smf92unu() {
        return Util.ConvertFlag(this.data, this.smf92uf2(), 64);
    }

    public boolean smf92udo() {
        return Util.ConvertFlag(this.data, this.smf92uf2(), 32);
    }

    public boolean smf92usn() {
        return Util.ConvertFlag(this.data, this.smf92uf2(), 16);
    }

    public static FileSystemUnmountRemount create(byte[] Data2, int offset, int length) {
        return new FileSystemUnmountRemount(Data2, offset, length);
    }

    static enum Field {
        smf92utm(0, 8),
        smf92utu(8, 8),
        smf92uft(16, 4),
        smf92ufm(20, 4),
        smf92udn(24, 4),
        smf92udd(28, 8),
        smf92utn(36, 8),
        smf92ufn(44, 44),
        smf92ubl(88, 4),
        smf92ust(92, 8),
        smf92usu(100, 8),
        smf92usr(108, 4),
        smf92usw(112, 4),
        smf92udi(116, 4),
        smf92uir(120, 4),
        smf92uiw(124, 4),
        smf92ubr(128, 8),
        smf92ubw(136, 8),
        smf92ufg(144, 1),
        smf92uf2(145, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

