/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.LockContentionEntry;
import com.blackhillsoftware.smf.smf92.SleepContentionEntry;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LockAndSleepStatistics
extends SmfData {
    private List<LockContentionEntry> _lockContention = null;
    private List<SleepContentionEntry> _sleepContentions = null;
    public static final int SMF92ST4_LEN = 72;

    private LockAndSleepStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92lkt() {
        return Util.Binary16StckeTime(this.data, 0);
    }

    public BigInteger smf92lktRawValue() {
        return Util.ConvertBigInteger(this.data, 0, 16);
    }

    public long smf92lkuts() {
        return Util.ConvertUnsignedBinary8(this.data, 16);
    }

    public BigInteger smf92lkutsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 16);
    }

    public long smf92lkts() {
        return Util.ConvertUnsignedBinary8(this.data, 24);
    }

    public BigInteger smf92lktsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public long smf92lkwk() {
        return Util.ConvertUnsignedBinary8(this.data, 32);
    }

    public BigInteger smf92lkwkAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public long smf92lkwt() {
        return Util.ConvertUnsignedBinary8(this.data, 40);
    }

    public BigInteger smf92lkwtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public Duration smf92lkwtt() {
        return Util.Binary8MSSeconds(this.data, 48);
    }

    public double smf92lkwttSeconds() {
        return Util.ToSeconds(this.smf92lkwtt());
    }

    public BigInteger smf92lkwttRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long smf92lktst() {
        return Util.ConvertUnsignedBinary8(this.data, 56);
    }

    public BigInteger smf92lktstAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public int smf92lklll() {
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf92lkllc() {
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public int smf92lksll() {
        return Util.ConvertUnsignedBinary2(this.data, 68);
    }

    public int smf92lkslc() {
        return Util.ConvertUnsignedBinary2(this.data, 70);
    }

    public List<LockContentionEntry> lockContentionEntries() {
        if (this._lockContention == null) {
            ArrayList<LockContentionEntry> list = new ArrayList<LockContentionEntry>(this.smf92lkllc());
            for (int i = 0; i < this.smf92lkllc(); ++i) {
                list.add(LockContentionEntry.create(this.data, 72 + i * this.smf92lklll(), this.smf92lklll()));
            }
            this._lockContention = Collections.unmodifiableList(list);
        }
        return this._lockContention;
    }

    public List<SleepContentionEntry> sleepContentionEntries() {
        if (this._sleepContentions == null) {
            ArrayList<SleepContentionEntry> list = new ArrayList<SleepContentionEntry>(this.smf92lkslc());
            for (int i = 0; i < this.smf92lkslc(); ++i) {
                list.add(SleepContentionEntry.create(this.data, 72 + this.smf92lkllc() * this.smf92lklll() + i * this.smf92lksll(), this.smf92lksll()));
            }
            this._sleepContentions = Collections.unmodifiableList(list);
        }
        return this._sleepContentions;
    }

    public static LockAndSleepStatistics create(byte[] Data2, int offset, int length) {
        return new LockAndSleepStatistics(Data2, offset, length);
    }

    static enum Field {
        smf92lkt(0, 16),
        smf92lkuts(16, 8),
        smf92lkts(24, 8),
        smf92lkwk(32, 8),
        smf92lkwt(40, 8),
        smf92lkwtt(48, 8),
        smf92lktst(56, 8),
        smf92lklll(64, 2),
        smf92lkllc(66, 2),
        smf92lksll(68, 2),
        smf92lkslc(70, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

