/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf98;

import java.util.HashMap;
import java.util.Map;

public enum JobPriority {
    ALL(65535),
    HIGH(1),
    MEDIUM(2),
    LOW(3),
    DISC(4),
    NOT_DEFINED(-2);

    private static Map<Integer, JobPriority> valueMap;
    private final transient int jobPriority;

    private JobPriority(int jobPriority) {
        this.jobPriority = jobPriority;
    }

    public static JobPriority from(int value) {
        if (value == -1) {
            return ALL;
        }
        JobPriority result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int jobPriority() {
        return this.jobPriority;
    }

    static {
        valueMap = new HashMap<Integer, JobPriority>();
        for (JobPriority x : JobPriority.values()) {
            if (x.jobPriority < 0) continue;
            valueMap.put(x.jobPriority, x);
        }
    }
}

