/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf98.zos;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf98.JobPriority;
import com.blackhillsoftware.smf.smf98.JobSize;
import com.blackhillsoftware.smf.smf98.zos.PriorityRange;
import com.blackhillsoftware.smf.smf98.zos.SizeRange;
import java.util.ArrayList;
import java.util.List;

public final class EnvironmentalSection
extends SmfData {
    public static final int SMF98_1_ENV_SVTAFFON = 128;
    public static final int SMF98_1_ENV_SVTLGACT = 64;
    public static final int SMF98_1_ENV_SVTHDCPR = 32;
    public static final int SMF98_1_ENV_CvtProcAsCore = 16;
    public static final int SMF98_1_ENV_CvtMultiCpusPerCore = 8;
    public static final int SMF98_1_ENV_CoreMixedMode_CP = 4;
    public static final int SMF98_1_ENV_CoreMixedMode_zCBP = 2;
    public static final int SMF98_1_ENV_CoreMixedMode_zAAP = 2;
    public static final int SMF98_1_ENV_CoreMixedMode_zIIP = 1;
    public static final int SMF98_1_ENV_SVTForceCoreMode_1 = 128;
    public static final int SMF98_1_ENV_CvtzCBP = 64;
    public static final int SMF98_1_ENV_WorkloadIntCorrFeature = 8;
    public static final int SMF98_1_ENV_SVTCR_Actv = 128;
    private List<PriorityRange> m_smf981EnvSvtPriorityRanges = null;
    private int[] m_smf981EnvSvtPriorityRangeRawValues = null;
    private List<SizeRange> m_smf981EnvSvtSubBucketRanges = null;
    private int[] m_smf981EnvSvtSubBucketRangeRawValues = null;

    private EnvironmentalSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int flagsByte1() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean svtAffOn() {
        return Util.ConvertFlag(this.data, this.flagsByte1(), 128);
    }

    public boolean svtlgact() {
        return Util.ConvertFlag(this.data, this.flagsByte1(), 64);
    }

    public boolean svthdcpr() {
        return Util.ConvertFlag(this.data, this.flagsByte1(), 32);
    }

    public boolean cvtProcAsCore() {
        return Util.ConvertFlag(this.data, this.flagsByte1(), 16);
    }

    public boolean cvtMultiCpusPerCore() {
        return Util.ConvertFlag(this.data, this.flagsByte1(), 8);
    }

    public boolean coreMixedModeCp() {
        return Util.ConvertFlag(this.data, this.flagsByte1(), 4);
    }

    public boolean coreMixedModeZcbp() {
        return Util.ConvertFlag(this.data, this.flagsByte1(), 2);
    }

    public boolean coreMixedModeZaap() {
        return Util.ConvertFlag(this.data, this.flagsByte1(), 2);
    }

    public boolean coreMixedModeZiip() {
        return Util.ConvertFlag(this.data, this.flagsByte1(), 1);
    }

    public int flagsByte2() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public boolean svtForceCoreMode1() {
        return Util.ConvertFlag(this.data, this.flagsByte2(), 128);
    }

    public boolean cvtzCbp() {
        return Util.ConvertFlag(this.data, this.flagsByte2(), 64);
    }

    public boolean workloadIntCorrFeature() {
        return Util.ConvertFlag(this.data, this.flagsByte2(), 8);
    }

    public int flagsByte3() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public int svtcr() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public boolean svtcrActv() {
        return Util.ConvertFlag(this.data, this.svtcr(), 128);
    }

    public int svtCoreModeMax() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public int svtCoreModeCp() {
        return Util.ConvertUnsignedBinary2(this.data, 6);
    }

    public int svtCoreModeZcbp() {
        return Util.ConvertUnsignedBinary2(this.data, 8);
    }

    public int svtCoreModeZaap() {
        return Util.ConvertUnsignedBinary2(this.data, 8);
    }

    public int svtCoreModeZiip() {
        return Util.ConvertUnsignedBinary2(this.data, 10);
    }

    public long awmtCp() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long awmtZcbp() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long awmtZaap() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long svtZcbpAwmtElapsedTimer() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long svtIfaAwmtElapsedTimer() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long awmtZiip() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long svtZiipAwmtElapsedTimer() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long svtSupAwmtElapsedTimer() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public int svtMaxQl() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int svtZcbpMaxQl() {
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    public int svtZaapMaxQl() {
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    public int svtZiipMaxQl() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int svtMinHl() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public int svtZcbpMinHl() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int svtZaapMinHl() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int svtZiipMinHl() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public long onlineCoresCps() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long onlineCoresZcbps() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long onlineCoresZaaps() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long onlineCoresZiips() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long numVhCoresCp() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long numVhCoresZcbp() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long numVhCoresZaap() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long numVhCoresZiip() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long numVmCoresCp() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long numVmCoresZcbp() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long numVmCoresZaap() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long numVmCoresZiip() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public long numVlUnparkedCoresCp() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long numVlUnparkedCoresZcbp() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public long numVlUnparkedCoresZaap() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public long numVlUnparkedCoresZiip() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public long numVlParkedCoresCp() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public long numVlParkedCoresZcbp() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public long numVlParkedCoresZaap() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public long numVlParkedCoresZiip() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public long numExcludedCp() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    public long numExcludedZcbp() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    public long numExcludedZaap() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    public long numExcludedZiip() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public long svtCpEngineSpeed() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public long svtSpecialtyEngineSpeed() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public List<PriorityRange> svtPriorityRanges() {
        if (this.m_smf981EnvSvtPriorityRanges != null) {
            return this.m_smf981EnvSvtPriorityRanges;
        }
        int[] rawValues = this.svtPriorityRangeRawValues();
        ArrayList<PriorityRange> result = new ArrayList<PriorityRange>();
        result.add(new PriorityRange(JobPriority.ALL, 255, 192));
        result.add(new PriorityRange(JobPriority.HIGH, 255, rawValues[0]));
        result.add(new PriorityRange(JobPriority.MEDIUM, rawValues[0] - 1, rawValues[1]));
        result.add(new PriorityRange(JobPriority.LOW, rawValues[1] - 1, rawValues[2]));
        result.add(new PriorityRange(JobPriority.DISC, rawValues[2] - 1, 192));
        this.m_smf981EnvSvtPriorityRanges = result;
        return this.m_smf981EnvSvtPriorityRanges;
    }

    public PriorityRange svtPriorityRange(JobPriority priority) {
        List<PriorityRange> sizes = this.svtPriorityRanges();
        for (int i = 0; i < sizes.size(); ++i) {
            if (sizes.get(i).priority() != priority) continue;
            return sizes.get(i);
        }
        return null;
    }

    public int[] svtPriorityRangeRawValues() {
        if (this.m_smf981EnvSvtPriorityRangeRawValues != null) {
            return this.m_smf981EnvSvtPriorityRangeRawValues;
        }
        int all = Util.ConvertUnsignedBinary3(this.data, 148);
        this.m_smf981EnvSvtPriorityRangeRawValues = new int[3];
        this.m_smf981EnvSvtPriorityRangeRawValues[0] = all >> 16 & 0xFF;
        this.m_smf981EnvSvtPriorityRangeRawValues[1] = all >> 8 & 0xFF;
        this.m_smf981EnvSvtPriorityRangeRawValues[2] = all & 0xFF;
        return this.m_smf981EnvSvtPriorityRangeRawValues;
    }

    public int vcmCpsPerNode() {
        return Util.ConvertUnsignedBinary1(this.data, 151);
    }

    public long qdepthAnalysisDelta() {
        return Util.ConvertUnsignedBinary4(this.data, 152);
    }

    public long numCoreExcludedCp() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public long numCoreExcludedZcbp() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public long numCoreExcludedZaap() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public long numCoreExcludedZiip() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public List<SizeRange> svtSubBucketRanges() {
        if (this.m_smf981EnvSvtSubBucketRanges != null) {
            return this.m_smf981EnvSvtSubBucketRanges;
        }
        int[] rawValues = this.svtSubBucketRangeRawValues();
        ArrayList<SizeRange> result = new ArrayList<SizeRange>();
        result.add(new SizeRange(JobSize.ALL, 1.0, 0.0));
        result.add(new SizeRange(JobSize.LARGE, 1.0, this.subBucketRangePct(rawValues[0])));
        result.add(new SizeRange(JobSize.MEDIUM, this.subBucketRangePct(rawValues[0]), this.subBucketRangePct(rawValues[1])));
        result.add(new SizeRange(JobSize.SMALL, this.subBucketRangePct(rawValues[1]), this.subBucketRangePct(rawValues[2])));
        result.add(new SizeRange(JobSize.TINY, this.subBucketRangePct(rawValues[2]), 0.0));
        this.m_smf981EnvSvtSubBucketRanges = result;
        return this.m_smf981EnvSvtSubBucketRanges;
    }

    public SizeRange svtSubBucketRange(JobSize size) {
        List<SizeRange> sizes = this.svtSubBucketRanges();
        for (int i = 0; i < sizes.size(); ++i) {
            if (sizes.get(i).size() != size) continue;
            return sizes.get(i);
        }
        return null;
    }

    private double subBucketRangePct(int rawValue) {
        return 0.5 * (double)rawValue / 100.0;
    }

    public int[] svtSubBucketRangeRawValues() {
        if (this.m_smf981EnvSvtSubBucketRangeRawValues != null) {
            return this.m_smf981EnvSvtSubBucketRangeRawValues;
        }
        int all = Util.ConvertUnsignedBinary3(this.data, 168);
        this.m_smf981EnvSvtSubBucketRangeRawValues = new int[3];
        this.m_smf981EnvSvtSubBucketRangeRawValues[0] = all >> 16 & 0xFF;
        this.m_smf981EnvSvtSubBucketRangeRawValues[1] = all >> 8 & 0xFF;
        this.m_smf981EnvSvtSubBucketRangeRawValues[2] = all & 0xFF;
        return this.m_smf981EnvSvtSubBucketRangeRawValues;
    }

    public static EnvironmentalSection create(byte[] Data2, int offset, int length) {
        return new EnvironmentalSection(Data2, offset, length);
    }

    static enum Field {
        flagsByte1(0, 1),
        flagsByte2(1, 1),
        flagsByte3(2, 1),
        svtcr(3, 1),
        svtCoreModeMax(4, 2),
        svtCoreModeCp(6, 2),
        svtCoreModeZcbp(8, 2),
        svtCoreModeZaap(8, 2),
        svtCoreModeZiip(10, 2),
        awmtCp(12, 4),
        awmtZcbp(16, 4),
        awmtZaap(16, 4),
        svtZcbpAwmtElapsedTimer(16, 4),
        svtIfaAwmtElapsedTimer(16, 4),
        awmtZiip(20, 4),
        svtZiipAwmtElapsedTimer(20, 4),
        svtSupAwmtElapsedTimer(20, 4),
        svtMaxQl(24, 2),
        svtZcbpMaxQl(26, 2),
        svtZaapMaxQl(26, 2),
        svtZiipMaxQl(28, 2),
        svtMinHl(30, 2),
        svtZcbpMinHl(32, 2),
        svtZaapMinHl(32, 2),
        svtZiipMinHl(34, 2),
        onlineCoresCps(68, 4),
        onlineCoresZcbps(72, 4),
        onlineCoresZaaps(72, 4),
        onlineCoresZiips(76, 4),
        numVhCoresCp(80, 4),
        numVhCoresZcbp(84, 4),
        numVhCoresZaap(84, 4),
        numVhCoresZiip(88, 4),
        numVmCoresCp(92, 4),
        numVmCoresZcbp(96, 4),
        numVmCoresZaap(96, 4),
        numVmCoresZiip(100, 4),
        numVlUnparkedCoresCp(104, 4),
        numVlUnparkedCoresZcbp(108, 4),
        numVlUnparkedCoresZaap(108, 4),
        numVlUnparkedCoresZiip(112, 4),
        numVlParkedCoresCp(116, 4),
        numVlParkedCoresZcbp(120, 4),
        numVlParkedCoresZaap(120, 4),
        numVlParkedCoresZiip(124, 4),
        numExcludedCp(128, 4),
        numExcludedZcbp(132, 4),
        numExcludedZaap(132, 4),
        numExcludedZiip(136, 4),
        svtCpEngineSpeed(140, 4),
        svtSpecialtyEngineSpeed(144, 4),
        svtPriorityRanges(148, 1),
        vcmCpsPerNode(151, 1),
        qdepthAnalysisDelta(152, 4),
        numCoreExcludedCp(156, 4),
        numCoreExcludedZcbp(160, 4),
        numCoreExcludedZaap(160, 4),
        numCoreExcludedZiip(164, 4),
        svtSubBucketRanges(168, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

