/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.svpol;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class ServiceClassInformation
extends SmfData {
    public static final int SVPOLCDH = 128;
    public static final int SVPOLCPC = 64;
    public static final int SVPOLSTR = 32;
    public static final int SVPOLTRA = 16;
    public static final int SVPOLADR = 8;
    public static final int SVPOLENC = 4;
    public static final int SVPOLSYH = 2;
    public static final int SVPOLIPG = 1;
    public static final int SVPOL_INELIGHONORPRIORITY = 128;
    public static final int SVPOLCEW = 128;

    private ServiceClassInformation(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String svpolcnm() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String svpolcde() {
        return Util.ConvertEbcdic(this.data, 8, 32);
    }

    public String svpolcwn() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public String svpolcrn() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public int svpolcpo() {
        return Util.ConvertSignedBinary4(this.data, 56);
    }

    public int svpolcpn() {
        return Util.ConvertUnsignedBinary2(this.data, 60);
    }

    public int svpolcf1() {
        return Util.ConvertUnsignedBinary1(this.data, 62);
    }

    public boolean svpolcdh() {
        return Util.ConvertFlag(this.data, this.svpolcf1(), 128);
    }

    public boolean svpolcpc() {
        return Util.ConvertFlag(this.data, this.svpolcf1(), 64);
    }

    public boolean svpolstr() {
        return Util.ConvertFlag(this.data, this.svpolcf1(), 32);
    }

    public boolean svpoltra() {
        return Util.ConvertFlag(this.data, this.svpolcf1(), 16);
    }

    public boolean svpoladr() {
        return Util.ConvertFlag(this.data, this.svpolcf1(), 8);
    }

    public boolean svpolenc() {
        return Util.ConvertFlag(this.data, this.svpolcf1(), 4);
    }

    public boolean svpolsyh() {
        return Util.ConvertFlag(this.data, this.svpolcf1(), 2);
    }

    public boolean svpolipg() {
        return Util.ConvertFlag(this.data, this.svpolcf1(), 1);
    }

    public int svpolcf2() {
        return Util.ConvertUnsignedBinary1(this.data, 63);
    }

    public boolean svpolIneligHonorPriority() {
        return Util.ConvertFlag(this.data, this.svpolcf2(), 128);
    }

    public int svpolcgi() {
        return Util.ConvertSignedBinary4(this.data, 64);
    }

    public int svpolcwi() {
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public String svpolcen() {
        return Util.ConvertEbcdic(this.data, 72, 64);
    }

    public int svpolcek() {
        return Util.ConvertUnsignedBinary2(this.data, 138);
    }

    public int svpolcef() {
        return Util.ConvertUnsignedBinary1(this.data, 140);
    }

    public boolean svpolcew() {
        return Util.ConvertFlag(this.data, this.svpolcef(), 128);
    }

    public int svpolcsi() {
        return Util.ConvertUnsignedBinary2(this.data, 142);
    }

    public static ServiceClassInformation create(byte[] Data2, int offset, int length) {
        return new ServiceClassInformation(Data2, offset, length);
    }

    static enum Field {
        svpolcnm(0, 8),
        svpolcde(8, 32),
        svpolcwn(40, 8),
        svpolcrn(48, 8),
        svpolcpo(56, 4),
        svpolcpn(60, 2),
        svpolcf1(62, 1),
        svpolcf2(63, 1),
        svpolcgi(64, 4),
        svpolcwi(68, 4),
        svpolcen(72, 64),
        svpolcek(138, 2),
        svpolcef(140, 1),
        svpolcsi(142, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

