/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.svpol;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.svpol.GpmpSettings;
import com.blackhillsoftware.svpol.GpmpSystemsExcluded;
import com.blackhillsoftware.svpol.ReportClassInformation;
import com.blackhillsoftware.svpol.ResourceGroupInformation;
import com.blackhillsoftware.svpol.ServiceClassInformation;
import com.blackhillsoftware.svpol.ServicePolicyInformation;
import com.blackhillsoftware.svpol.WorkloadInformation;
import java.util.List;

public final class ServicePolicy
extends SmfData {
    private boolean complete = false;
    private ServicePolicyInformation m_ServicePolicyInformation = null;
    private List<WorkloadInformation> m_WorkloadInformation = null;
    private List<ServiceClassInformation> m_ServiceClassInformation = null;
    private List<ResourceGroupInformation> m_ResourceGroupInformation = null;
    private List<ReportClassInformation> m_ReportClassInformation = null;
    private GpmpSettings m_GpmpSettings = null;
    private List<GpmpSystemsExcluded> m_GpmpSystemsExcluded = null;
    public static final int SVPOLSH2 = 128;
    public static final int SVPOLEWL = 64;
    public static final int SVPOLEWM = 32;
    public static final int SVPOLEWU = 16;
    public static final int SVPOL_SECTION = 0;
    public static final int SVPOL_HDR_SECTION = 1;
    public static final int SVPOL_SP_SECTION = 2;
    public static final int SVPOL_WD_SECTION = 3;
    public static final int SVPOL_CD_SECTION = 4;
    public static final int SVPOL_PD_SECTION = 5;
    public static final int SVPOL_RG_SECTION = 6;
    public static final int SVPOL_RD_SECTION = 7;
    public static final int SVPOL_MS_SECTION = 8;
    public static final int SVPOL_SN_SECTION = 9;

    private ServicePolicy(byte[] Data2, int offset, int length, boolean complete) {
        super(Data2, offset, length);
        this.complete = complete;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public ServicePolicyInformation servicePolicyInformation() {
        this.m_ServicePolicyInformation = Util.sectionFrom42Doublet(this.m_ServicePolicyInformation, this.data, Field.svpoldpo.offset, ServicePolicyInformation::create);
        return this.m_ServicePolicyInformation;
    }

    public List<WorkloadInformation> workloadInformation() {
        this.m_WorkloadInformation = Util.sectionsFrom422Triplet(this.m_WorkloadInformation, this.data, Field.svpoldwo.offset, WorkloadInformation::create);
        return this.m_WorkloadInformation;
    }

    public List<ServiceClassInformation> serviceClassInformation() {
        this.m_ServiceClassInformation = Util.sectionsFrom422Triplet(this.m_ServiceClassInformation, this.data, Field.svpoldco.offset, ServiceClassInformation::create);
        return this.m_ServiceClassInformation;
    }

    public List<ResourceGroupInformation> resourceGroupInformation() {
        this.m_ResourceGroupInformation = Util.sectionsFrom422Triplet(this.m_ResourceGroupInformation, this.data, Field.svpoldgo.offset, ResourceGroupInformation::create);
        return this.m_ResourceGroupInformation;
    }

    public List<ReportClassInformation> reportClassInformation() {
        this.m_ReportClassInformation = Util.sectionsFrom422Triplet(this.m_ReportClassInformation, this.data, Field.svpoldro.offset, ReportClassInformation::create);
        return this.m_ReportClassInformation;
    }

    public GpmpSettings gpmpSettings() {
        this.m_GpmpSettings = Util.sectionFrom422Triplet(this.m_GpmpSettings, this.data, Field.svpolemo.offset, GpmpSettings::create);
        return this.m_GpmpSettings;
    }

    public List<GpmpSystemsExcluded> gpmpSystemsExcluded() {
        this.m_GpmpSystemsExcluded = Util.sectionsFrom422Triplet(this.m_GpmpSystemsExcluded, this.data, Field.svpoleso.offset, GpmpSystemsExcluded::create);
        return this.m_GpmpSystemsExcluded;
    }

    public String svpolnam() {
        return Util.ConvertEbcdic(this.data, 0, 4);
    }

    public int svpollvl() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int svpolwvn() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public int svpoldil() {
        return Util.ConvertUnsignedBinary2(this.data, 6);
    }

    public int svpoldle() {
        return Util.ConvertSignedBinary4(this.data, 8);
    }

    public int svpoldpo() {
        return Util.ConvertSignedBinary4(this.data, 12);
    }

    public int svpoldpl() {
        return Util.ConvertUnsignedBinary2(this.data, 16);
    }

    public int svpoldwo() {
        return Util.ConvertSignedBinary4(this.data, 20);
    }

    public int svpoldwc() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int svpoldwl() {
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    public int svpoldco() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int svpoldcc() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int svpoldcl() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int svpoldzo() {
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int svpoldzc() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int svpoldzl() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int svpoldro() {
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int svpoldrc() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int svpoldrl() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int svpoldgo() {
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int svpoldgc() {
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int svpoldgl() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int svpolfl1() {
        return Util.ConvertUnsignedBinary1(this.data, 60);
    }

    public boolean svpolsh2() {
        return Util.ConvertFlag(this.data, this.svpolfl1(), 128);
    }

    public boolean svpolewl() {
        return Util.ConvertFlag(this.data, this.svpolfl1(), 64);
    }

    public boolean svpolewm() {
        return Util.ConvertFlag(this.data, this.svpolfl1(), 32);
    }

    public boolean svpolewu() {
        return Util.ConvertFlag(this.data, this.svpolfl1(), 16);
    }

    public int svpolemo() {
        return Util.ConvertSignedBinary4(this.data, 64);
    }

    public int svpolemc() {
        return Util.ConvertUnsignedBinary2(this.data, 68);
    }

    public int svpoleml() {
        return Util.ConvertUnsignedBinary2(this.data, 70);
    }

    public int svpoleso() {
        return Util.ConvertSignedBinary4(this.data, 72);
    }

    public int svpolesc() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public int svpolesl() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public static ServicePolicy create(byte[] Data2, int offset, int length, boolean complete) {
        return new ServicePolicy(Data2, offset, length, complete);
    }

    static enum Field {
        svpolnam(0, 4),
        svpollvl(4, 1),
        svpolwvn(5, 1),
        svpoldil(6, 2),
        svpoldle(8, 4),
        svpoldpo(12, 4),
        svpoldpl(16, 2),
        svpoldwo(20, 4),
        svpoldwc(24, 2),
        svpoldwl(26, 2),
        svpoldco(28, 4),
        svpoldcc(32, 2),
        svpoldcl(34, 2),
        svpoldzo(36, 4),
        svpoldzc(40, 2),
        svpoldzl(42, 2),
        svpoldro(44, 4),
        svpoldrc(48, 2),
        svpoldrl(50, 2),
        svpoldgo(52, 4),
        svpoldgc(56, 2),
        svpoldgl(58, 2),
        svpolfl1(60, 1),
        svpolemo(64, 4),
        svpolemc(68, 2),
        svpoleml(70, 2),
        svpoleso(72, 4),
        svpolesc(76, 2),
        svpolesl(78, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

