/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.svpse;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.svpse.SchedulingEnvironmentEntry;
import com.blackhillsoftware.svpse.SchedulingEnvironmentResourcesEntry;
import com.blackhillsoftware.svpse.SchedulingResourcesEntry;
import java.util.List;

public final class SchedulingEnvironment
extends SmfData {
    private List<SchedulingEnvironmentEntry> m_SchedulingEnvironmentEntry = null;
    private List<SchedulingEnvironmentResourcesEntry> m_SchedulingEnvironmentResourcesEntry = null;
    private List<SchedulingResourcesEntry> m_SchedulingResourcesEntry = null;
    private boolean complete;
    public static final int SVPSE_SECTION = 1;
    public static final int SVPSE_HDR_SECTION = 2;
    public static final int SVPSE_SE_SECTION = 3;
    public static final int SVPSE_SR_SECTION = 4;
    public static final int SVPSE_RE_SECTION = 5;

    private SchedulingEnvironment(byte[] Data2, int offset, int length, boolean complete) {
        super(Data2, offset, length);
        this.complete = complete;
    }

    public List<SchedulingEnvironmentEntry> schedulingEnvironmentEntries() {
        this.m_SchedulingEnvironmentEntry = Util.sectionsFromTriplet(this.m_SchedulingEnvironmentEntry, this.data, () -> this.svpseOffsetSe(), () -> this.svpseSizeSe(), () -> this.svpseNumberSe(), SchedulingEnvironmentEntry::create);
        return this.m_SchedulingEnvironmentEntry;
    }

    public List<SchedulingEnvironmentResourcesEntry> schedulingEnvironmentResourcesEntries() {
        this.m_SchedulingEnvironmentResourcesEntry = Util.sectionsFromTriplet(this.m_SchedulingEnvironmentResourcesEntry, this.data, () -> this.svpseOffsetSr(), () -> this.svpseSizeSr(), () -> this.svpseNumberSr(), SchedulingEnvironmentResourcesEntry::create);
        return this.m_SchedulingEnvironmentResourcesEntry;
    }

    public List<SchedulingResourcesEntry> schedulingResourcesEntries() {
        this.m_SchedulingResourcesEntry = Util.sectionsFromTriplet(this.m_SchedulingResourcesEntry, this.data, () -> this.svpseOffsetRe(), () -> this.svpseSizeRe(), () -> this.svpseNumberRe(), SchedulingResourcesEntry::create);
        return this.m_SchedulingResourcesEntry;
    }

    public boolean complete() {
        return this.complete;
    }

    public String svpseEyecatcher() {
        return Util.ConvertEbcdic(this.data, 0, 4);
    }

    public int svpseFunctionalityLevel() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int svpseWlmVersionNumber() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public int svpseSizeOfHeader() {
        return Util.ConvertUnsignedBinary2(this.data, 6);
    }

    public int svpseSizeOfWholeSvpse() {
        return Util.ConvertSignedBinary4(this.data, 8);
    }

    public long svpseSvpseSeq() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public int svpseOffsetSe() {
        return Util.ConvertSignedBinary4(this.data, 16);
    }

    public int svpseNumberSe() {
        return Util.ConvertUnsignedBinary2(this.data, 20);
    }

    public int svpseSizeSe() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int svpseOffsetSr() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    public int svpseNumberSr() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int svpseSizeSr() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public int svpseOffsetRe() {
        return Util.ConvertSignedBinary4(this.data, 32);
    }

    public int svpseNumberRe() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public int svpseSizeRe() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public int svpseExtDataOff() {
        return Util.ConvertSignedBinary4(this.data, 72);
    }

    public int svpseExtDataLen() {
        return Util.ConvertSignedBinary4(this.data, 76);
    }

    public int svpseExtOffSe() {
        return Util.ConvertSignedBinary4(this.data, 80);
    }

    public int svpseExtNumSe() {
        return Util.ConvertUnsignedBinary2(this.data, 84);
    }

    public int svpseExtSizSe() {
        return Util.ConvertUnsignedBinary2(this.data, 86);
    }

    public static SchedulingEnvironment create(byte[] Data2, int offset, int length, boolean complete) {
        return new SchedulingEnvironment(Data2, offset, length, complete);
    }

    static enum Field {
        svpseEyecatcher(0, 4),
        svpseFunctionalityLevel(4, 1),
        svpseWlmVersionNumber(5, 1),
        svpseSizeOfHeader(6, 2),
        svpseSizeOfWholeSvpse(8, 4),
        svpseSvpseSeq(12, 4),
        svpseOffsetSe(16, 4),
        svpseNumberSe(20, 2),
        svpseSizeSe(22, 2),
        svpseOffsetSr(24, 4),
        svpseNumberSr(28, 2),
        svpseSizeSr(30, 2),
        svpseOffsetRe(32, 4),
        svpseNumberRe(36, 2),
        svpseSizeRe(38, 2),
        svpseExtDataOff(72, 4),
        svpseExtDataLen(76, 4),
        svpseExtOffSe(80, 4),
        svpseExtNumSe(84, 2),
        svpseExtSizSe(86, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

