/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.dcollect;

import com.blackhillsoftware.dcollect.ActiveDataset;
import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.smf.VRecordReader;
import java.io.IOException;
import java.time.LocalDate;
import java.time.Period;
import java.util.Map;
import java.util.TreeMap;

public class DatasetsByLastRef {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: DatasetsByLastRef <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        LocalDate rundate = LocalDate.now();
        TreeMap<LocalDate, DatasetGroup> datasetsByAge = new TreeMap<LocalDate, DatasetGroup>();
        datasetsByAge.put(rundate, new DatasetGroup());
        datasetsByAge.put(rundate.minusDays(7L), new DatasetGroup());
        datasetsByAge.put(rundate.minusMonths(1L), new DatasetGroup());
        datasetsByAge.put(rundate.minusMonths(6L), new DatasetGroup());
        datasetsByAge.put(rundate.minusYears(1L), new DatasetGroup());
        datasetsByAge.put(rundate.minusYears(5L), new DatasetGroup());
        try (VRecordReader reader = VRecordReader.fromName(args[0]);){
            reader.stream().map(DcollectRecord::from).filter(r -> r.dcurctyp().equals((Object)DcollectType.D)).map(ActiveDataset::from).forEach(datasetRecord -> {
                LocalDate lastref = datasetRecord.dcdlstrf() != null ? datasetRecord.dcdlstrf() : datasetRecord.dcdcredt();
                Map.Entry agegroup = datasetsByAge.ceilingEntry(lastref);
                if (agegroup == null) {
                    agegroup = datasetsByAge.lastEntry();
                }
                ((DatasetGroup)agegroup.getValue()).add((ActiveDataset)datasetRecord);
            });
        }
        System.out.format("%-8s %8s %10s %10s%n", "Last Ref", "Count", "Alloc MB", "Used MB");
        datasetsByAge.entrySet().stream().forEachOrdered(entry -> System.out.format("%-8s %8d %10.1f %10.1f%n", Period.between((LocalDate)entry.getKey(), rundate), ((DatasetGroup)entry.getValue()).count, ((DatasetGroup)entry.getValue()).allocatedMB, ((DatasetGroup)entry.getValue()).usedMB));
    }

    private static class DatasetGroup {
        int count = 0;
        double allocatedMB = 0.0;
        double usedMB = 0.0;

        private DatasetGroup() {
        }

        void add(ActiveDataset ds) {
            ++this.count;
            this.allocatedMB += ds.dcdallsxMB();
            this.usedMB += ds.dcdusesxMB();
        }
    }
}

