/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.dcollect.MigratedDataset;
import com.blackhillsoftware.smf.VRecordReader;
import java.io.IOException;
import java.time.LocalDate;
import java.time.Period;
import java.util.Map;
import java.util.TreeMap;

public class DatasetsByMigratedDate {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: DatasetsByMigratedDate <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        LocalDate rundate = LocalDate.now();
        TreeMap<LocalDate, DatasetGroup> datasetsByMigDate = new TreeMap<LocalDate, DatasetGroup>();
        datasetsByMigDate.put(rundate, new DatasetGroup());
        datasetsByMigDate.put(rundate.minusDays(7L), new DatasetGroup());
        datasetsByMigDate.put(rundate.minusMonths(1L), new DatasetGroup());
        datasetsByMigDate.put(rundate.minusMonths(6L), new DatasetGroup());
        datasetsByMigDate.put(rundate.minusYears(1L), new DatasetGroup());
        datasetsByMigDate.put(rundate.minusYears(5L), new DatasetGroup());
        try (VRecordReader reader = VRecordReader.fromName(args[0]);){
            reader.stream().map(DcollectRecord::from).filter(r -> r.dcurctyp().equals((Object)DcollectType.M)).map(MigratedDataset::from).forEach(record -> {
                Map.Entry agegroup = datasetsByMigDate.ceilingEntry(record.umdate());
                if (agegroup == null) {
                    agegroup = datasetsByMigDate.lastEntry();
                }
                ((DatasetGroup)agegroup.getValue()).add((MigratedDataset)record);
            });
        }
        System.out.format("%-8s %8s %10s %10s%n", "Migrated", "Count", "Migrat MB", "Size MB");
        datasetsByMigDate.entrySet().stream().forEachOrdered(entry -> System.out.format("%-8s %8d %10.1f %10.1f%n", Period.between((LocalDate)entry.getKey(), rundate), ((DatasetGroup)entry.getValue()).count, ((DatasetGroup)entry.getValue()).migratedMB, ((DatasetGroup)entry.getValue()).recallSpaceMB));
    }

    private static class DatasetGroup {
        int count = 0;
        double migratedMB = 0.0;
        double recallSpaceMB = 0.0;

        private DatasetGroup() {
        }

        void add(MigratedDataset ds) {
            ++this.count;
            this.migratedMB += ds.umdsizeMB();
            this.recallSpaceMB += ds.umrecspMB();
        }
    }
}

