/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.dcollect.SmsVolume;
import com.blackhillsoftware.smf.VRecordReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DeltaStorageGroups {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: DeltaStorageGroups <input-name-1> <input-name-2>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<String, StorageGroupInfo> storageGroups = new HashMap<String, StorageGroupInfo>();
        try (VRecordReader reader = VRecordReader.fromName(args[0]);){
            reader.stream().map(DcollectRecord::from).filter(record -> record.dcurctyp().equals((Object)DcollectType.VL)).map(SmsVolume::from).forEach(volumerecord -> storageGroups.computeIfAbsent(volumerecord.dvlstgrp(), key -> new StorageGroupInfo()).addA((SmsVolume)volumerecord));
        }
        reader = VRecordReader.fromName(args[1]);
        try {
            reader.stream().map(DcollectRecord::from).filter(record -> record.dcurctyp().equals((Object)DcollectType.VL)).map(SmsVolume::from).forEach(volumerecord -> storageGroups.computeIfAbsent(volumerecord.dvlstgrp(), key -> new StorageGroupInfo()).addB((SmsVolume)volumerecord));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        DeltaStorageGroups.reportDeltas(storageGroups);
    }

    private static void reportDeltas(Map<String, StorageGroupInfo> storageGroups) {
        storageGroups.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> {
            StorageGroupInfo storagegroup = (StorageGroupInfo)entry.getValue();
            System.out.format("%nStorage Group : %-30s%n", entry.getKey());
            System.out.format("%8s %10s %10s %10s %10s%n", "", "Volumes", "Tot MB", "Free MB", "Used%");
            System.out.format("%8s %,10d %,10d %,10d %10.1f%n", "A:", storagegroup.volCountA, storagegroup.spaceMBA, storagegroup.freeMBA, storagegroup.usedA());
            System.out.format("%8s %,10d %,10d %,10d %10.1f%n", "B:", storagegroup.volCountB, storagegroup.spaceMBB, storagegroup.freeMBB, storagegroup.usedB());
            System.out.format("%8s %+,10d %+,10d %+,10d %+10.1f%n", "Change:", storagegroup.deltaVolumes(), storagegroup.deltaSpace(), storagegroup.deltaFree(), storagegroup.deltaUsedPct());
        });
    }

    private static class StorageGroupInfo {
        int volCountA = 0;
        long spaceMBA = 0L;
        long freeMBA = 0L;
        int volCountB = 0;
        long spaceMBB = 0L;
        long freeMBB = 0L;

        private StorageGroupInfo() {
        }

        double usedA() {
            return (double)(this.spaceMBA - this.freeMBA) / (double)this.spaceMBA * 100.0;
        }

        double usedB() {
            return (double)(this.spaceMBB - this.freeMBB) / (double)this.spaceMBB * 100.0;
        }

        int deltaVolumes() {
            return this.volCountB - this.volCountA;
        }

        long deltaSpace() {
            return this.spaceMBB - this.spaceMBA;
        }

        long deltaFree() {
            return this.freeMBB - this.freeMBA;
        }

        double deltaUsedPct() {
            return this.usedB() - this.usedA();
        }

        void addA(SmsVolume ds) {
            ++this.volCountA;
            this.spaceMBA += ds.dvlntcpy();
            this.freeMBA += ds.dvlnfree();
        }

        void addB(SmsVolume ds) {
            ++this.volCountB;
            this.spaceMBB += ds.dvlntcpy();
            this.freeMBB += ds.dvlnfree();
        }
    }
}

