/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.json.EasySmfGsonBuilder;
import com.blackhillsoftware.smf.VRecordReader;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SmsClasses {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: SmsClasses <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        try (VRecordReader reader = VRecordReader.fromName(args[0]);){
            Map<DcollectType, List<DcollectRecord>> smsClasses = reader.stream().map(DcollectRecord::from).filter(r -> r.dcurctyp().equals((Object)DcollectType.DC) || r.dcurctyp().equals((Object)DcollectType.SC) || r.dcurctyp().equals((Object)DcollectType.MC)).collect(Collectors.groupingBy(r -> r.dcurctyp()));
            Gson gson = new EasySmfGsonBuilder().includeZeroValues(false).includeEmptyStrings(false).includeUnsetFlags(false).exclude("recordLength").exclude("dculeng").setPrettyPrinting().createGson();
            System.out.println(gson.toJson(smsClasses));
        }
    }
}

