/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.dcollect.SmsVolume;
import com.blackhillsoftware.smf.VRecordReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageGroups {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: StorageGroups <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<String, StorageGroupInfo> storageGroups = new HashMap<String, StorageGroupInfo>();
        try (VRecordReader reader = VRecordReader.fromName(args[0]);){
            reader.stream().map(DcollectRecord::from).filter(record -> record.dcurctyp().equals((Object)DcollectType.VL)).map(SmsVolume::from).forEach(volumerecord -> storageGroups.computeIfAbsent(volumerecord.dvlstgrp(), key -> new StorageGroupInfo()).add((SmsVolume)volumerecord));
        }
        StorageGroups.storageGroupSummary(storageGroups);
        StorageGroups.storageGroupVolumes(storageGroups);
    }

    private static void storageGroupSummary(Map<String, StorageGroupInfo> storageGroups) {
        System.out.format("%-30s %10s %10s %10s %10s %10s%n", "Storage Group", "Volumes", "Tot MB", "Free MB", "Used%", "Lrgst MB");
        storageGroups.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> {
            StorageGroupInfo storagegroup = (StorageGroupInfo)entry.getValue();
            System.out.format("%-30s %,10d %,10d %,10d %10.1f %,10d%n", entry.getKey(), storagegroup.volCount, storagegroup.spaceMB, storagegroup.freeMB, storagegroup.usedPct(), storagegroup.largestMB);
        });
    }

    private static void storageGroupVolumes(Map<String, StorageGroupInfo> storageGroups) {
        storageGroups.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> {
            StorageGroupInfo storagegroup = (StorageGroupInfo)entry.getValue();
            System.out.format("%nStorage Group: %s%n%n", entry.getKey());
            System.out.format("%-8s %10s %10s %10s %10s%n", "Volume", "Tot MB", "Free MB", "Used%", "Lrgst MB");
            storagegroup.volumes.stream().sorted(Comparator.comparing(vol -> vol.volser)).forEachOrdered(vol -> System.out.format("%-8s %,10d %,10d %10.1f %,10d%n", vol.volser, vol.spaceMB, vol.freeMB, vol.usedPct(), vol.largestMB));
        });
    }

    private static class StorageGroupInfo {
        int volCount = 0;
        long spaceMB = 0L;
        long freeMB = 0L;
        long largestMB = 0L;
        List<VolumeInfo> volumes = new ArrayList<VolumeInfo>();

        private StorageGroupInfo() {
        }

        void add(SmsVolume smsVolumeRecord) {
            VolumeInfo volumeInfo = new VolumeInfo(smsVolumeRecord);
            ++this.volCount;
            this.spaceMB += volumeInfo.spaceMB;
            this.freeMB += volumeInfo.freeMB;
            this.largestMB = Math.max(this.largestMB, volumeInfo.largestMB);
            this.volumes.add(volumeInfo);
        }

        double usedPct() {
            return (double)(this.spaceMB - this.freeMB) / (double)this.spaceMB * 100.0;
        }
    }

    private static class VolumeInfo {
        String volser;
        long spaceMB;
        long freeMB;
        long largestMB;

        public VolumeInfo(SmsVolume smsVolumeRecord) {
            this.volser = smsVolumeRecord.dvlvser();
            this.spaceMB = smsVolumeRecord.dvlntcpy();
            this.freeMB = smsVolumeRecord.dvlnfree();
            this.largestMB = smsVolumeRecord.dvlnlext();
        }

        double usedPct() {
            return (double)(this.spaceMB - this.freeMB) / (double)this.spaceMB * 100.0;
        }
    }
}

