/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.sample;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf72.Smf72Record;
import com.blackhillsoftware.smf.smf72.subtype3.ServiceReportClassPeriodDataSection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ZiipVelocity {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: ZiipVelocity <input-name>");
            return;
        }
        HashMap<String, Map> intervalsBySystem = new HashMap<String, Map>();
        try (SmfRecordReader reader = SmfRecordReader.fromName(args[0]).include(72, 3);){
            for (SmfRecord record : reader) {
                Smf72Record r72 = Smf72Record.from(record);
                if (r72.workloadManagerControlSection().r723mrcl()) continue;
                ZiipVelocityData intervalData = intervalsBySystem.computeIfAbsent(r72.system(), systemEntry -> new HashMap()).computeIfAbsent(r72.productSection().smf72iet().withZoneSameInstant(r72.productSection().smf72lgo()), intervalEntry -> new ZiipVelocityData());
                for (ServiceReportClassPeriodDataSection scPeriod : r72.serviceReportClassPeriodDataSections()) {
                    intervalData.add(scPeriod);
                }
            }
        }
        intervalsBySystem.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(systemEntry -> {
            System.out.format("%nSystem: %s%n%n", systemEntry.getKey());
            ((Map)systemEntry.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(intervalEntry -> System.out.format("%-35s %3.0f%n", intervalEntry.getKey(), ((ZiipVelocityData)intervalEntry.getValue()).velocity().orElse(null)));
        });
    }

    private static class ZiipVelocityData {
        private double using = 0.0;
        private double delay = 0.0;

        private ZiipVelocityData() {
        }

        void add(ServiceReportClassPeriodDataSection scPeriod) {
            this.using += (double)scPeriod.r723supu();
            this.delay += (double)scPeriod.r723supd();
        }

        Optional<Double> velocity() {
            if (this.using == 0.0 && this.delay == 0.0) {
                return Optional.empty();
            }
            return Optional.of(this.using / (this.using + this.delay) * 100.0);
        }
    }
}

