/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json;

import com.blackhillsoftware.json.internal.Hexadecimal;
import com.blackhillsoftware.smf.SmfData;
import java.util.ArrayList;
import java.util.List;

class CicsTranFlags
extends SmfData {
    private int[] flags;
    private final int FACILITY_NONE = 128;
    private final int FACILITY_TERMINAL = 64;
    private final int FACILITY_SURROGATE = 32;
    private final int FACILITY_DESTINATION = 16;
    private final int FACILITY_3270_BRIDGE = 8;
    private final int ID_SYSTEM = 128;
    private final int ID_MIRROR = 64;
    private final int ID_DPL_MIRROR = 32;
    private final int ID_ONC_RPC_ALIAS = 16;
    private final int ID_WEB_ALIAS = 8;
    private final int ID_3270_BRIDGE = 4;
    private final int ID_RESERVED = 2;
    private final int ID_BTS_RUN = 1;
    private final int WLM_REPORT_TOTAL_RESP_TIME = 128;
    private final int WLM_NOTIFY_EXECUTION_COMPLETE = 64;
    private final int WLM_NOTIFY_SUBSET_COMPLETE = 32;
    private final int WLM_DB2_CONNECTION_UNAVAILABLE = 16;
    private final int TASKDATALOC_BELOW = 128;
    private final int TASKDATAKEY_CICS = 64;
    private final int ISOLATE_NO = 32;
    private final int DYNAMIC_YES = 16;
    private final int STATUS_ORIGIN = 128;
    private final int RESOURCE_CLASS_RECORD = 32;
    private final int IDENTITY_CLASS_RECORD = 16;
    private final int TCB_TERMINATED = 2;
    private final int TASK_TERMINATED = 1;
    private final int INDOUBT_WAIT_NO = 128;
    private final int INDOUBT_ACTION_COMMIT = 64;
    private final int UOW_RESOLVED_INDOUBT = 32;
    private final int RECOVERY_MANAGER_SHUNT = 16;
    private final int RECOVERY_MANAGER_UNSHUNT = 8;
    private final int RECOVERY_MANAGER_INDOUBT_FAILURE = 4;
    private final int RECOVERY_MANAGER_RESOURCE_OWNER_FAILURE = 2;

    CicsTranFlags(byte[] flagBytes) {
        super(null);
        if (flagBytes.length != 8) {
            throw new IllegalArgumentException("Expected 8 bytes of flags, got " + this.flags.length);
        }
        this.flags = new int[8];
        for (int i = 0; i < 8; ++i) {
            this.flags[i] = flagBytes[i] & 0xFF;
        }
    }

    private boolean facilityNone() {
        return (this.flags[0] & 0x80) != 0;
    }

    private boolean facilityTerminal() {
        return (this.flags[0] & 0x40) != 0;
    }

    private boolean facilitySurrogate() {
        return (this.flags[0] & 0x20) != 0;
    }

    private boolean facilityDestination() {
        return (this.flags[0] & 0x10) != 0;
    }

    private boolean facility3270Bridge() {
        return (this.flags[0] & 8) != 0;
    }

    public Object originFacilityType() {
        if (this.flags[0] == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.facilityNone()) {
            result.add("None");
        }
        if (this.facilityTerminal()) {
            result.add("Terminal");
        }
        if (this.facilitySurrogate()) {
            result.add("Surrogate");
        }
        if (this.facilityDestination()) {
            result.add("Destination");
        }
        if (this.facility3270Bridge()) {
            result.add("Bridge");
        }
        if (result.size() == 0) {
            return "Unknown";
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        return result;
    }

    boolean idSystem() {
        return (this.flags[1] & 0x80) != 0;
    }

    boolean idMirror() {
        return (this.flags[1] & 0x40) != 0;
    }

    boolean idDplMirror() {
        return (this.flags[1] & 0x20) != 0;
    }

    boolean idOncRpcAlias() {
        return (this.flags[1] & 0x10) != 0;
    }

    boolean idWebAlias() {
        return (this.flags[1] & 8) != 0;
    }

    boolean id3270Bridge() {
        return (this.flags[1] & 4) != 0;
    }

    boolean idReserved() {
        return (this.flags[1] & 2) != 0;
    }

    boolean idBtsRun() {
        return (this.flags[1] & 1) != 0;
    }

    public Object identificationInfo() {
        if (this.flags[1] == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.idSystem()) {
            result.add("System");
        }
        if (this.idMirror()) {
            result.add("Mirror");
        }
        if (this.idDplMirror()) {
            result.add("DPL Mirror");
        }
        if (this.idOncRpcAlias()) {
            result.add("ONC/RPC Alias");
        }
        if (this.idWebAlias()) {
            result.add("Web Alias");
        }
        if (this.id3270Bridge()) {
            result.add("Bridge");
        }
        if (this.idReserved()) {
            result.add("Reserved");
        }
        if (this.idBtsRun()) {
            result.add("BTS Run");
        }
        if (result.size() == 0) {
            return null;
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        return result;
    }

    boolean wlmReportTotalRespTime() {
        return (this.flags[2] & 0x80) != 0;
    }

    boolean wlmNotifyExecutionComplete() {
        return (this.flags[2] & 0x40) != 0;
    }

    boolean wlmNotifySubsetComplete() {
        return (this.flags[2] & 0x20) != 0;
    }

    boolean wlmDb2ConnectionUnavailable() {
        return (this.flags[2] & 0x10) != 0;
    }

    public List<String> wlmCompletionInfo() {
        if (this.flags[2] == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.wlmReportTotalRespTime()) {
            result.add("WLM Report");
        }
        if (this.wlmNotifyExecutionComplete()) {
            result.add("WLM Notify - Completion");
        }
        if (this.wlmNotifySubsetComplete()) {
            result.add("WLM Notify");
        }
        if (this.wlmDb2ConnectionUnavailable()) {
            result.add("DB2 Connection Unavailable");
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    boolean taskdatalocBelow() {
        return (this.flags[3] & 0x80) != 0;
    }

    boolean taskdatakeyCics() {
        return (this.flags[3] & 0x40) != 0;
    }

    boolean isolateNo() {
        return (this.flags[3] & 0x20) != 0;
    }

    boolean dynamicYes() {
        return (this.flags[3] & 0x10) != 0;
    }

    public List<String> transactionDefinitionInfo() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.taskdatalocBelow()) {
            result.add("Taskdataloc Below");
        }
        if (this.taskdatakeyCics()) {
            result.add("Taskdatakey CICS");
        }
        if (this.isolateNo()) {
            result.add("Isolate No");
        }
        if (this.dynamicYes()) {
            result.add("Dynamic Yes");
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public String transactionOrigin() {
        switch (this.flags[4]) {
            case 1: {
                return "None";
            }
            case 2: {
                return "Terminal";
            }
            case 3: {
                return "Transient Data";
            }
            case 4: {
                return "Start";
            }
            case 5: {
                return "Terminal Start";
            }
            case 6: {
                return "BTS";
            }
            case 7: {
                return "XM Transaction";
            }
            case 8: {
                return "Bridge";
            }
            case 9: {
                return "Sockets Domain";
            }
            case 10: {
                return "CWS";
            }
            case 11: {
                return "IIOP";
            }
            case 12: {
                return "RRS";
            }
            case 13: {
                return "LU61";
            }
            case 14: {
                return "LU62 APPC";
            }
            case 15: {
                return "MRO";
            }
            case 16: {
                return "ECI";
            }
            case 17: {
                return "IIOP Receiver";
            }
            case 18: {
                return "RZ Instore Transport";
            }
            case 19: {
                return "IPIC";
            }
            case 20: {
                return "Event";
            }
            case 21: {
                return "JVMSERVER";
            }
            case 22: {
                return "Async Transaction";
            }
            case 23: {
                return "NODEJSAPP";
            }
        }
        return Hexadecimal.byteString[this.flags[4]];
    }

    boolean isOrigin() {
        return (this.flags[5] & 0x80) != 0;
    }

    boolean resourceClassRecord() {
        return (this.flags[5] & 0x20) != 0;
    }

    boolean identityClassRecord() {
        return (this.flags[5] & 0x10) != 0;
    }

    boolean tcbTerminated() {
        return (this.flags[5] & 2) != 0;
    }

    boolean taskTerminated() {
        return (this.flags[5] & 1) != 0;
    }

    public List<String> transactionStatus() {
        if (this.flags[5] == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.isOrigin()) {
            result.add("Origin");
        }
        if (this.resourceClassRecord()) {
            result.add("Resource Class record");
        }
        if (this.identityClassRecord()) {
            result.add("Identity Class record");
        }
        if (this.tcbTerminated()) {
            result.add("Purge or runaway TCB terminated");
        }
        if (this.taskTerminated()) {
            result.add("Task terminated");
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public String trackingTag() {
        return this.flags[6] == 0 || !this.isOrigin() ? null : Hexadecimal.byteString[this.flags[6]];
    }

    boolean indoubtWaitNo() {
        return (this.flags[7] & 0x80) != 0;
    }

    boolean indoubtActionCommit() {
        return (this.flags[7] & 0x40) != 0;
    }

    boolean uowResolvedIndoubt() {
        return (this.flags[7] & 0x20) != 0;
    }

    boolean recoveryManagerShunt() {
        return (this.flags[7] & 0x10) != 0;
    }

    boolean recoveryManagerUnshunt() {
        return (this.flags[7] & 8) != 0;
    }

    boolean recoveryManagerIndoubtFailure() {
        return (this.flags[7] & 4) != 0;
    }

    boolean recoveryManagerResourceOwnerFailure() {
        return (this.flags[7] & 2) != 0;
    }

    public List<String> recoveryManagerInformation() {
        if (this.flags[7] == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.indoubtWaitNo()) {
            result.add("Indoubt Wait No");
        }
        if (this.indoubtActionCommit()) {
            result.add("Indoubt Action Commit");
        }
        if (this.uowResolvedIndoubt()) {
            result.add("UOW Indoubt Action");
        }
        if (this.recoveryManagerShunt()) {
            result.add("UOW Shunt");
        }
        if (this.recoveryManagerUnshunt()) {
            result.add("UOW Unshunt");
        }
        if (this.recoveryManagerIndoubtFailure()) {
            result.add("Indoubt Failure");
        }
        if (this.recoveryManagerResourceOwnerFailure()) {
            result.add("Resource Owner Failure");
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }
}

