/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json;

import com.blackhillsoftware.json.CompositeEntryTypeAdapter;
import com.blackhillsoftware.json.SerializeCicsClock;
import com.blackhillsoftware.json.SerializeCicsSummaryEntry;
import com.blackhillsoftware.json.SerializeCicsTransactionGroup;
import com.blackhillsoftware.json.SerializeData;
import com.blackhillsoftware.json.SerializeDouble;
import com.blackhillsoftware.json.SerializeFloat;
import com.blackhillsoftware.json.SerializeHashKey;
import com.blackhillsoftware.json.SerializeInstant;
import com.blackhillsoftware.json.SerializeOffsetDateTime;
import com.blackhillsoftware.json.SerializeTopN;
import com.blackhillsoftware.json.SerializeZonedDateTime;
import com.blackhillsoftware.json.cics.CicsTransactionGroup;
import com.blackhillsoftware.json.internal.CicsSummaryEntry;
import com.blackhillsoftware.json.internal.Configuration;
import com.blackhillsoftware.json.util.CompositeEntry;
import com.blackhillsoftware.json.util.HashKey;
import com.blackhillsoftware.smf.Data;
import com.blackhillsoftware.smf.cics.monitoring.CicsClock;
import com.blackhillsoftware.smf.summary.Top;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;

class EasySmfTypeAdapterFactory
implements TypeAdapterFactory {
    Configuration config;

    EasySmfTypeAdapterFactory(Configuration config) {
        this.config = config;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        if (typeToken.getRawType() == Double.class && this.config.avoidScientificNotation()) {
            return new SerializeDouble(this.config.getDecimalPlaces());
        }
        if (typeToken.getRawType() == Float.class && this.config.avoidScientificNotation()) {
            return new SerializeFloat(this.config.getDecimalPlaces());
        }
        if (typeToken.getRawType() == CompositeEntry.class) {
            return new CompositeEntryTypeAdapter(gson);
        }
        if (typeToken.getRawType() == Instant.class) {
            return new SerializeInstant(this.config.timesAsEpochSeconds());
        }
        if (typeToken.getRawType() == OffsetDateTime.class) {
            return new SerializeOffsetDateTime(this.config.timesAsEpochSeconds());
        }
        if (typeToken.getRawType() == ZonedDateTime.class) {
            return new SerializeZonedDateTime(this.config.timesAsEpochSeconds());
        }
        if (typeToken.getRawType() == CicsClock.class) {
            return new SerializeCicsClock(this.config, gson);
        }
        if (typeToken.getRawType() == HashKey.class) {
            return new SerializeHashKey(this.config, gson);
        }
        if (typeToken.getRawType() == Top.class) {
            return new SerializeTopN(gson);
        }
        if (CicsTransactionGroup.class.isAssignableFrom(typeToken.getRawType())) {
            return new SerializeCicsTransactionGroup(gson, this.config);
        }
        if (CicsSummaryEntry.class.isAssignableFrom(typeToken.getRawType())) {
            return new SerializeCicsSummaryEntry(gson, this.config);
        }
        if (Data.class.isAssignableFrom(typeToken.getRawType())) {
            return new SerializeData(gson, typeToken, this.config);
        }
        return null;
    }
}

