/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

final class SerializeByteArray
extends TypeAdapter<byte[]> {
    SerializeByteArray() {
    }

    public void write(JsonWriter out, byte[] value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (String line : SerializeByteArray.dump(value)) {
            out.value(line);
        }
        out.endArray();
    }

    public byte[] read(JsonReader in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static List<String> dump(byte[] data) {
        int out;
        int offset = 0;
        int length = data.length;
        int bytesPerLine = 16;
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder outputLine = new StringBuilder();
        length = Math.min(length, data.length - offset);
        for (out = 0; out <= length - bytesPerLine; out += bytesPerLine) {
            outputLine.append(String.format("%08X :", offset + out));
            for (int i = 0; i < bytesPerLine / 4; ++i) {
                int bytes = ByteBuffer.wrap(data, offset + out + i * 4, 4).getInt();
                outputLine.append(String.format(" %08X", bytes));
            }
            result.add(outputLine.toString());
            outputLine = new StringBuilder();
        }
        if (out < length) {
            int bytes;
            outputLine.append(String.format("%08X :", offset + out));
            while (out <= length - 4) {
                bytes = ByteBuffer.wrap(data, offset + out, 4).getInt();
                outputLine.append(String.format(" %08X", bytes));
                out += 4;
            }
            if (out <= length - 1) {
                outputLine.append(" ");
                while (out <= length - 1) {
                    bytes = data[offset + out] & 0xFF;
                    outputLine.append(String.format("%02X", bytes));
                    ++out;
                }
            }
            result.add(outputLine.toString());
        }
        return result;
    }
}

