/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json;

import com.blackhillsoftware.json.internal.CicsSummaryClockDetailed;
import com.blackhillsoftware.json.internal.CicsSummaryClockSimple;
import com.blackhillsoftware.json.internal.CicsSummaryCountStats;
import com.blackhillsoftware.json.internal.CicsSummaryElapsed;
import com.blackhillsoftware.json.internal.CicsSummaryEntry;
import com.blackhillsoftware.json.internal.CicsSummaryObject;
import com.blackhillsoftware.json.internal.CicsSummaryPacked;
import com.blackhillsoftware.json.internal.CicsSummaryStringSet;
import com.blackhillsoftware.json.internal.CicsSummaryTimestamp;
import com.blackhillsoftware.json.internal.Configuration;
import com.blackhillsoftware.json.internal.Hexadecimal;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Set;

final class SerializeCicsSummaryEntry
extends TypeAdapter<CicsSummaryEntry> {
    private Configuration config;
    private TypeAdapter<Set<String>> stringSetTypeAdapter;
    private TypeAdapter<ZonedDateTime> zonedDateTimeTypeAdapter;
    private TypeAdapter<Double> doubleTypeAdapter = null;

    public SerializeCicsSummaryEntry(Gson gson, Configuration config) {
        this.config = config;
        this.stringSetTypeAdapter = gson.getAdapter((TypeToken)new TypeToken<Set<String>>(){});
        this.zonedDateTimeTypeAdapter = gson.getAdapter(ZonedDateTime.class);
        if (config.avoidScientificNotation()) {
            this.doubleTypeAdapter = gson.getAdapter(Double.class);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(JsonWriter out, CicsSummaryEntry value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        if (this.config.includeValue(value) || this.config.alwaysInclude(PerformanceRecord.class, value.getName()) || value.errors() != null) {
            if (value instanceof CicsSummaryCountStats) {
                CicsSummaryCountStats src = (CicsSummaryCountStats)value;
                out.beginObject();
                out.name("min").value(src.getMin());
                out.name("max").value(src.getMax());
                out.name("total").value(src.getTotal());
                if (src.errors() != null) {
                    out.name("errors");
                    this.stringSetTypeAdapter.write(out, src.errors());
                }
                out.endObject();
                return;
            } else if (value instanceof CicsSummaryPacked) {
                CicsSummaryPacked src = (CicsSummaryPacked)value;
                out.beginObject();
                out.name("min").value(src.getMin());
                out.name("max").value(src.getMax());
                out.name("total").value(src.getTotal());
                if (src.errors() != null) {
                    out.name("errors");
                    this.stringSetTypeAdapter.write(out, src.errors());
                }
                out.endObject();
                return;
            } else if (value instanceof CicsSummaryClockSimple) {
                CicsSummaryClockSimple src = (CicsSummaryClockSimple)value;
                out.beginObject();
                if (this.doubleTypeAdapter != null) {
                    out.name("min");
                    this.doubleTypeAdapter.write(out, (Object)src.getMin());
                    out.name("max");
                    this.doubleTypeAdapter.write(out, (Object)src.getMax());
                    out.name("total");
                    this.doubleTypeAdapter.write(out, (Object)src.getTotal());
                } else {
                    out.name("min").value(src.getMin());
                    out.name("max").value(src.getMax());
                    out.name("total").value(src.getTotal());
                }
                if (src.errors() != null) {
                    out.name("errors");
                    this.stringSetTypeAdapter.write(out, src.errors());
                }
                out.endObject();
                return;
            } else if (value instanceof CicsSummaryClockDetailed) {
                CicsSummaryClockDetailed src = (CicsSummaryClockDetailed)value;
                out.beginObject();
                if (this.doubleTypeAdapter != null) {
                    out.name("min");
                    this.doubleTypeAdapter.write(out, (Object)src.getMin());
                    out.name("max");
                    this.doubleTypeAdapter.write(out, (Object)src.getMax());
                    out.name("total");
                    this.doubleTypeAdapter.write(out, (Object)src.getTotal());
                } else {
                    out.name("min").value(src.getMin());
                    out.name("max").value(src.getMax());
                    out.name("total").value(src.getTotal());
                }
                out.name("count").value((long)src.getCount());
                if (src.getFlags() != 0 || this.config.includeUnsetFlags()) {
                    out.name("flags").value(Hexadecimal.byteString[src.getFlags()]);
                }
                if (src.errors() != null) {
                    out.name("errors");
                    this.stringSetTypeAdapter.write(out, src.errors());
                }
                out.endObject();
                return;
            } else if (value instanceof CicsSummaryStringSet) {
                CicsSummaryStringSet src = (CicsSummaryStringSet)value;
                out.beginObject();
                if (src.getValues() != null) {
                    out.name("values");
                    this.stringSetTypeAdapter.write(out, src.getValues());
                }
                if (src.errors() != null) {
                    out.name("errors");
                    this.stringSetTypeAdapter.write(out, src.errors());
                }
                out.endObject();
                return;
            } else if (value instanceof CicsSummaryElapsed) {
                CicsSummaryElapsed src = (CicsSummaryElapsed)value;
                out.beginObject();
                if (this.doubleTypeAdapter != null) {
                    out.name("min");
                    this.doubleTypeAdapter.write(out, (Object)src.getMin());
                    out.name("max");
                    this.doubleTypeAdapter.write(out, (Object)src.getMax());
                    out.name("total");
                    this.doubleTypeAdapter.write(out, (Object)src.getTotal());
                } else {
                    out.name("min").value(src.getMin());
                    out.name("max").value(src.getMax());
                    out.name("total").value(src.getTotal());
                }
                out.name("count").value((long)src.getCount());
                if (src.errors() != null) {
                    out.name("errors");
                    this.stringSetTypeAdapter.write(out, src.errors());
                }
                out.endObject();
                return;
            } else if (value instanceof CicsSummaryTimestamp) {
                CicsSummaryTimestamp src = (CicsSummaryTimestamp)value;
                out.beginObject();
                out.name("min");
                this.zonedDateTimeTypeAdapter.write(out, (Object)src.getMin());
                out.name("max");
                this.zonedDateTimeTypeAdapter.write(out, (Object)src.getMax());
                if (src.errors() != null) {
                    out.name("errors");
                    this.stringSetTypeAdapter.write(out, src.errors());
                }
                out.endObject();
                return;
            } else {
                if (!(value instanceof CicsSummaryObject)) throw new RuntimeException("Type not implememnted : " + value.getClass().getName());
                CicsSummaryObject src = (CicsSummaryObject)value;
                out.beginObject();
                out.name("entries").value((long)src.getCount());
                if (src.errors() != null) {
                    out.name("errors");
                    this.stringSetTypeAdapter.write(out, src.errors());
                }
                out.endObject();
            }
            return;
        } else {
            out.nullValue();
        }
    }

    public CicsSummaryEntry read(JsonReader in) throws IOException {
        throw new UnsupportedOperationException();
    }
}

