/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json;

import com.blackhillsoftware.json.DoubleFormats;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

final class SerializeDouble
extends TypeAdapter<Double> {
    Integer places;
    private static ThreadLocal<DoubleFormats> formats = ThreadLocal.withInitial(DoubleFormats::new);

    public SerializeDouble(Integer places) {
        this.places = places;
    }

    public void write(JsonWriter out, Double value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.value(SerializeDouble.getNumber(value, this.places));
    }

    public Double read(JsonReader in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static Number getNumber(final Double src, final Integer places) {
        Number n = new Number(){
            private static final long serialVersionUID = 2625490446066543734L;
            private final Double value;
            {
                this.value = src;
            }

            @Override
            public long longValue() {
                double f = this.value;
                return (long)f;
            }

            @Override
            public int intValue() {
                double f = this.value;
                return (int)f;
            }

            @Override
            public float floatValue() {
                double f = this.value;
                return (float)f;
            }

            @Override
            public double doubleValue() {
                double f = this.value;
                return f;
            }

            public String toString() {
                block4: {
                    double absValue;
                    DoubleFormats myFormats;
                    block3: {
                        myFormats = (DoubleFormats)formats.get();
                        if (places != null) {
                            return myFormats.specificformatter[places].format(this.value);
                        }
                        absValue = Math.abs(this.value);
                        if (!(absValue < 1.0) || !(absValue >= myFormats.smallThresholds[myFormats.smallThresholds.length - 1])) break block3;
                        for (int i = 0; i < myFormats.smallThresholds.length; ++i) {
                            if (!(absValue >= myFormats.smallThresholds[i])) continue;
                            return myFormats.smallformatter[i].format(this.value);
                        }
                        break block4;
                    }
                    if (!(absValue < 1.0E13) || !(absValue >= myFormats.largeThresholds[0])) break block4;
                    for (int i = 0; i < myFormats.largeThresholds.length; ++i) {
                        if (!(absValue <= myFormats.largeThresholds[i])) continue;
                        return myFormats.largeformatter[i].format(this.value);
                    }
                }
                return this.value.toString();
            }
        };
        return n;
    }
}

