/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json;

import com.blackhillsoftware.json.FloatFormats;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

final class SerializeFloat
extends TypeAdapter<Float> {
    Integer places;
    private static ThreadLocal<FloatFormats> formats = ThreadLocal.withInitial(FloatFormats::new);

    public SerializeFloat(Integer places) {
        this.places = places;
    }

    public void write(JsonWriter out, Float value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.value(SerializeFloat.getNumber(value, this.places));
    }

    public Float read(JsonReader in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static Number getNumber(final Float src, final Integer places) {
        Number n = new Number(){
            private static final long serialVersionUID = 2625490446066543734L;
            private final Float value;
            {
                this.value = src;
            }

            @Override
            public long longValue() {
                float f = this.value.floatValue();
                return (long)f;
            }

            @Override
            public int intValue() {
                float f = this.value.floatValue();
                return (int)f;
            }

            @Override
            public float floatValue() {
                float f = this.value.floatValue();
                return f;
            }

            @Override
            public double doubleValue() {
                float f = this.value.floatValue();
                return f;
            }

            public String toString() {
                FloatFormats myFormats = (FloatFormats)formats.get();
                if (places != null) {
                    return myFormats.specificformatter[places].format(this.value);
                }
                float absValue = Math.abs(this.value.floatValue());
                if (absValue < 1.0f && absValue >= myFormats.thresholds[myFormats.thresholds.length - 1]) {
                    for (int i = 0; i < myFormats.thresholds.length; ++i) {
                        if (!(absValue >= myFormats.thresholds[i])) continue;
                        return myFormats.formatter[i].format(this.value);
                    }
                }
                return this.value.toString();
            }
        };
        return n;
    }
}

