/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json;

import com.blackhillsoftware.json.SerializeInstant;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

final class SerializeZonedDateTime
extends TypeAdapter<ZonedDateTime> {
    private final boolean asEpochSeconds;

    SerializeZonedDateTime(boolean asEpochSeconds) {
        this.asEpochSeconds = asEpochSeconds;
    }

    public void write(JsonWriter out, ZonedDateTime value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        if (this.asEpochSeconds) {
            out.value(SerializeInstant.getNumber(value.toInstant()));
        } else {
            out.value(value.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
    }

    public ZonedDateTime read(JsonReader in) throws IOException {
        throw new UnsupportedOperationException();
    }
}

