/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json.internal;

import com.blackhillsoftware.json.internal.CicsSummaryEntry;
import com.blackhillsoftware.json.internal.Configuration;
import com.blackhillsoftware.json.internal.Hexadecimal;
import com.blackhillsoftware.smf.cics.monitoring.CicsClock;
import com.blackhillsoftware.smf.cics.monitoring.DictionaryEntry;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.blackhillsoftware.smf.cics.monitoring.fields.ClockField;
import java.util.LinkedHashMap;

public class CicsSummaryClockDetailed
extends CicsSummaryEntry {
    private ClockField field;
    private double min = 0.0;
    private double max = 0.0;
    private double total = 0.0;
    private int count = 0;
    private int flags = 0;

    public CicsSummaryClockDetailed(String name, ClockField field, DictionaryEntry entry) {
        super(name, entry);
        this.field = field;
    }

    @Override
    public synchronized void add(PerformanceRecord section, boolean sameDictionary) {
        CicsClock clock = sameDictionary ? section.getClockField(this.getDictionaryEntry()) : section.getField(this.field);
        this.count += clock.count();
        double value = clock.timerSeconds();
        this.total += value;
        this.min = !this.containsData || value < this.min ? value : this.min;
        this.max = !this.containsData || value > this.max ? value : this.max;
        this.flags |= clock.flags();
        this.containsData = true;
    }

    @Override
    public synchronized Object getValue(Configuration config) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("min", this.min);
        result.put("max", this.max);
        result.put("total", this.total);
        result.put("count", this.count);
        if (this.flags != 0 || config.includeUnsetFlags()) {
            result.put("flags", Hexadecimal.byteString[this.flags]);
        }
        if (this.errors() != null) {
            result.put("errors", this.errors());
        }
        return result;
    }

    public synchronized boolean isZero() {
        return this.total == 0.0;
    }

    public ClockField getField() {
        return this.field;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getTotal() {
        return this.total;
    }

    public int getCount() {
        return this.count;
    }

    public int getFlags() {
        return this.flags;
    }
}

