/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json.internal;

import com.blackhillsoftware.json.internal.CicsSummaryEntry;
import com.blackhillsoftware.json.internal.Configuration;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import java.util.LinkedHashMap;

public class CicsSummaryElapsed
extends CicsSummaryEntry {
    private double min = 0.0;
    private double max = 0.0;
    private double total = 0.0;
    private int count = 0;

    public CicsSummaryElapsed(String name) {
        super(name, null);
    }

    @Override
    public synchronized void add(PerformanceRecord section, boolean sameDictionary) {
        ++this.count;
        double value = section.elapsedSeconds();
        this.total += value;
        this.min = !this.containsData || value < this.min ? value : this.min;
        this.max = !this.containsData || value > this.max ? value : this.max;
        this.containsData = true;
    }

    @Override
    public synchronized Object getValue(Configuration config) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("min", this.min);
        result.put("max", this.max);
        result.put("total", this.total);
        result.put("count", this.count);
        if (this.errors() != null) {
            result.put("errors", this.errors());
        }
        return result;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getTotal() {
        return this.total;
    }

    public int getCount() {
        return this.count;
    }
}

