/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json.internal;

import com.blackhillsoftware.json.internal.CicsSummaryClockDetailed;
import com.blackhillsoftware.json.internal.CicsSummaryClockSimple;
import com.blackhillsoftware.json.internal.CicsSummaryCountStats;
import com.blackhillsoftware.json.internal.CicsSummaryHex;
import com.blackhillsoftware.json.internal.CicsSummaryObject;
import com.blackhillsoftware.json.internal.CicsSummaryPacked;
import com.blackhillsoftware.json.internal.CicsSummaryRtype;
import com.blackhillsoftware.json.internal.CicsSummaryStringSet;
import com.blackhillsoftware.json.internal.CicsSummaryTimestamp;
import com.blackhillsoftware.json.internal.CicsSummaryTranNum;
import com.blackhillsoftware.json.internal.Configuration;
import com.blackhillsoftware.smf.cics.monitoring.DictionaryEntry;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.blackhillsoftware.smf.cics.monitoring.fields.ByteStringField;
import com.blackhillsoftware.smf.cics.monitoring.fields.ClockField;
import com.blackhillsoftware.smf.cics.monitoring.fields.CountField;
import com.blackhillsoftware.smf.cics.monitoring.fields.Field;
import com.blackhillsoftware.smf.cics.monitoring.fields.MonitoringField;
import com.blackhillsoftware.smf.cics.monitoring.fields.PackedField;
import com.blackhillsoftware.smf.cics.monitoring.fields.TimestampField;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

public abstract class CicsSummaryEntry {
    private final DictionaryEntry entry;
    private final String name;
    private Set<String> errors = null;
    protected transient boolean containsData = false;

    public abstract Object getValue(Configuration var1);

    public abstract void add(PerformanceRecord var1, boolean var2);

    protected CicsSummaryEntry(String name, DictionaryEntry entry) {
        this.name = name;
        this.entry = entry;
    }

    public synchronized void addError(String message) {
        if (this.errors == null) {
            this.errors = new LinkedHashSet<String>();
        }
        if (this.errors.size() < 3) {
            this.errors.add(message);
        } else if (this.errors.size() == 3 && !this.errors.contains(message)) {
            this.errors.add("more...");
        }
    }

    public synchronized Set<String> errors() {
        return this.errors;
    }

    public String getName() {
        return this.name;
    }

    public static CicsSummaryEntry forField(DictionaryEntry entry, Configuration config) {
        MonitoringField field = entry.field();
        field = Field.get((String)entry.cmodname(), (String)entry.entryId());
        if (field == null) {
            field = entry.field();
        }
        String fieldName = field.getName().toLowerCase(Locale.ROOT);
        switch (field.getName()) {
            case "RTYPE": {
                return new CicsSummaryRtype(fieldName, (ByteStringField)entry.field(), entry);
            }
            case "TERMINFO": 
            case "TASKFLAG": 
            case "TRANFLAG": 
            case "OTRANFLG": 
            case "NETUOWSX": 
            case "TRNGRPID": {
                return new CicsSummaryHex(fieldName, (CountField)entry.field(), entry);
            }
            case "TRANNUM": 
            case "OTRANNUM": 
            case "PTTRANNO": 
            case "PHTRANNO": {
                return new CicsSummaryTranNum(fieldName, (PackedField)entry.field(), entry);
            }
        }
        if (entry.field() instanceof CountField) {
            return new CicsSummaryCountStats(fieldName, (CountField)entry.field(), entry);
        }
        if (entry.field() instanceof ClockField) {
            return config.cicsClockDetail() ? new CicsSummaryClockDetailed(fieldName, (ClockField)entry.field(), entry) : new CicsSummaryClockSimple(fieldName, (ClockField)entry.field(), entry);
        }
        if (entry.field() instanceof ByteStringField) {
            return new CicsSummaryStringSet(fieldName, (ByteStringField)entry.field(), entry);
        }
        if (entry.field() instanceof TimestampField) {
            return new CicsSummaryTimestamp(fieldName, (TimestampField)entry.field(), entry);
        }
        if (entry.field() instanceof PackedField) {
            return new CicsSummaryPacked(fieldName, (PackedField)entry.field(), entry);
        }
        return new CicsSummaryObject(fieldName, entry.field(), entry);
    }

    protected DictionaryEntry getDictionaryEntry() {
        return this.entry;
    }
}

