/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CompositeEntry {
    private List<Element> items = new ArrayList<Element>();
    private Set<String> names = new HashSet<String>();
    private transient Map<String, Element> entriesByName = null;

    public CompositeEntry add(String key, Object entry) {
        Objects.requireNonNull(key);
        if (!this.names.add(key)) {
            throw new IllegalArgumentException("Duplicate key: " + key);
        }
        this.items.add(new Element(key, entry));
        return this;
    }

    public CompositeEntry add(Object entry) {
        this.items.add(new Element(entry));
        return this;
    }

    public Object getEntry(String name) {
        Element e;
        if (this.entriesByName == null) {
            this.entriesByName = new HashMap<String, Element>();
            for (Element e2 : this.items) {
                if (e2.name == null) continue;
                this.entriesByName.put(e2.getName(), e2);
            }
        }
        return (e = this.entriesByName.get(name)) != null ? e.getObject() : null;
    }

    public List<Element> getElements() {
        return this.items;
    }

    public String toString() {
        ArrayList<String> entries = new ArrayList<String>();
        for (Element e : this.getElements()) {
            if (e.name != null) {
                entries.add(e.name + "=" + (e.object == null ? "null" : e.object.toString()));
                continue;
            }
            entries.add(e.object == null ? "null" : e.object.toString());
        }
        return ((Object)entries).toString();
    }

    public static class Element {
        private Object object;
        private String name;

        Element(Object object) {
            this.object = object;
            this.name = null;
        }

        Element(String name, Object object) {
            this.object = object;
            this.name = name;
        }

        public Object getObject() {
            return this.object;
        }

        public String getName() {
            return this.name;
        }
    }
}

