/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HashKey
implements Comparable<HashKey> {
    private List<String> names = new ArrayList<String>();
    private List<Object> values = new ArrayList<Object>();
    private transient Map<String, Object> entriesByName = null;

    private HashKey() {
    }

    public static HashKey of(Object value) {
        HashKey result = new HashKey();
        result.names.add(null);
        result.values.add(value);
        return result;
    }

    public static HashKey of(String name, Object value) {
        HashKey result = new HashKey();
        result.names.add(name);
        result.values.add(value);
        return result;
    }

    public HashKey and(Object value) {
        this.names.add(null);
        this.values.add(value);
        return this;
    }

    public HashKey and(String name, Object value) {
        this.names.add(name);
        this.values.add(value);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashKey other = (HashKey)obj;
        return Objects.equals(this.names, other.names) && Objects.equals(this.values, other.values);
    }

    public Object getEntry(String name) {
        if (this.entriesByName == null) {
            this.entriesByName = new HashMap<String, Object>();
            for (int i = 0; i < this.names.size(); ++i) {
                if (this.names.get(i) == null) continue;
                this.entriesByName.put(this.names.get(i), this.values.get(i));
            }
        }
        return this.entriesByName.get(name);
    }

    public Map<String, Object> getNamedValues() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.values.size(); ++i) {
            if (this.names.get(i) == null) continue;
            result.put(this.names.get(i), this.values.get(i));
        }
        return result;
    }

    public String toString() {
        ArrayList<String> entries = new ArrayList<String>();
        for (int i = 0; i < this.values.size(); ++i) {
            if (this.names.get(i) != null) {
                entries.add(this.names.get(i) + "=" + this.values.get(i).toString());
                continue;
            }
            entries.add(this.values.get(i).toString());
        }
        return ((Object)entries).toString();
    }

    @Override
    public int compareTo(HashKey other) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (other.values.size() < i - 1) {
                return 1;
            }
            int nameComparison = this.compareNames(this.names.get(i), other.names.get(i));
            if (nameComparison != 0) {
                return nameComparison;
            }
            int valueComparison = this.compareValues(this.values.get(i), other.values.get(i));
            if (valueComparison == 0) continue;
            return valueComparison;
        }
        if (other.values.size() > this.values.size()) {
            return -1;
        }
        return 0;
    }

    private int compareNames(String a, String b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    private int compareValues(Object a, Object b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a.getClass() != b.getClass() || !(a instanceof Comparable)) {
            return a.toString().compareTo(b.toString());
        }
        return ((Comparable)a).compareTo(b);
    }
}

