/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.cics;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.cics.Smf110Record;
import com.blackhillsoftware.smf.cics.statistics.FileControlStatistics;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class CicsFileStatistics {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: CicsFileStatistics <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<String, Map<String, FileData>> applids = new HashMap<String, Map<String, FileData>>();
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]);){
            reader.include(110, 2);
            for (SmfRecord record : reader) {
                Smf110Record r110 = Smf110Record.from((SmfRecord)record);
                Map applidFiles = applids.computeIfAbsent(r110.stProductSection().smfstprn(), files -> new HashMap());
                for (FileControlStatistics fileStats : r110.fileControlStatistics()) {
                    String entryName = fileStats.a17fnam();
                    applidFiles.computeIfAbsent(entryName, x -> new FileData(entryName)).add(fileStats);
                }
            }
        }
        CicsFileStatistics.writeReport(applids);
    }

    private static void writeReport(Map<String, Map<String, FileData>> applidFiles) {
        applidFiles.entrySet().stream().filter(applid -> !((Map)applid.getValue()).isEmpty()).sorted((a, b) -> ((String)a.getKey()).compareTo((String)b.getKey())).forEachOrdered(applid -> {
            System.out.format("%n%-8s", applid.getKey());
            System.out.format("%n%-8s %12s %12s %12s %12s %12s %12s %12s %12s%n%n", "ID", "Gets", "Get Upd", "Browse", "Adds", "Updates", "Deletes", "Data EXCP", "Index EXCP");
            ((Map)applid.getValue()).entrySet().stream().map(files -> (FileData)files.getValue()).filter(file -> !file.noActivity()).sorted(Comparator.comparing(FileData::getTotalExcps).reversed()).forEachOrdered(fileInfo -> System.out.format("%-8s %12d %12d %12d %12d %12d %12d %12d %12d%n", fileInfo.getId(), fileInfo.getGets(), fileInfo.getGetUpd(), fileInfo.getBrowse(), fileInfo.getAdds(), fileInfo.getUpdates(), fileInfo.getDeletes(), fileInfo.getDataExcps(), fileInfo.getIndexExcps()));
        });
    }

    private static class FileData {
        private String id;
        private long gets = 0L;
        private long getupd = 0L;
        private long browse = 0L;
        private long add = 0L;
        private long update = 0L;
        private long delete = 0L;
        private long dataexcp = 0L;
        private long indexexcp = 0L;
        private long totalexcp = 0L;

        public FileData(String fileId) {
            this.id = fileId;
        }

        public void add(FileControlStatistics fileStatistics) {
            this.gets += fileStatistics.a17dsrd();
            this.getupd += fileStatistics.a17dsgu();
            this.browse += fileStatistics.a17dsbr();
            this.add = fileStatistics.a17dswra();
            this.update = fileStatistics.a17dswru();
            this.delete = fileStatistics.a17dsdel();
            this.dataexcp = fileStatistics.a17dsxcp();
            this.indexexcp = fileStatistics.a17dsixp();
            this.totalexcp += fileStatistics.a17dsxcp() + fileStatistics.a17dsixp();
        }

        public String getId() {
            return this.id;
        }

        public long getGets() {
            return this.gets;
        }

        public long getGetUpd() {
            return this.getupd;
        }

        public long getBrowse() {
            return this.browse;
        }

        public long getAdds() {
            return this.add;
        }

        public long getUpdates() {
            return this.update;
        }

        public long getDeletes() {
            return this.delete;
        }

        public long getDataExcps() {
            return this.dataexcp;
        }

        public long getIndexExcps() {
            return this.indexexcp;
        }

        public long getTotalExcps() {
            return this.totalexcp;
        }

        public boolean noActivity() {
            return this.gets == 0L && this.getupd == 0L && this.browse == 0L && this.add == 0L && this.update == 0L && this.delete == 0L && this.dataexcp == 0L && this.indexexcp == 0L && this.totalexcp == 0L;
        }
    }
}

