/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.dataset;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf14.Smf14Record;
import com.smfreports.dataset.DatasetActivityEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DatasetActivity {
    private static void printUsage() {
        System.out.println("Usage: DatasetActivity [-r] <dataset-pattern> <input-name>");
        System.out.println("-r : Include read activity, otherwise only update activity is reported");
        System.out.println("<dataset-pattern> : The dataset pattern to match. Wildcards:");
        System.out.println("    %  - A single character");
        System.out.println("    *  - Zero or more characters excluding period i.e. in a single qualifier");
        System.out.println("    ** - Zero or more characters, can be in multiple qualifiers");
        System.out.println("<input-name> : filename, //DD:DDNAME or //'DATASET.NAME'");
    }

    public static void main(String[] args) throws IOException {
        try {
            if (args.length < 2 || args[0].equals("--help") || args[0].equals("-h")) {
                DatasetActivity.printUsage();
                return;
            }
            int nextArg = 0;
            boolean includeReadActivity = false;
            if (args[nextArg].equals("-r")) {
                includeReadActivity = true;
            }
            int n = ++nextArg;
            String datasetFilter = args[n];
            Pattern regexPattern = DatasetActivity.buildPattern(datasetFilter);
            System.out.format("Dataset pattern is: %s%n", datasetFilter);
            System.out.format("Regex is: %s%n", regexPattern.pattern());
            int n2 = ++nextArg;
            ++nextArg;
            String inputName = args[n2];
            List<DatasetActivityEvent> events = DatasetActivity.processData(inputName, regexPattern, includeReadActivity);
            DatasetActivity.writeReport(events);
        }
        catch (Exception e) {
            DatasetActivity.printUsage();
            throw e;
        }
    }

    private static List<DatasetActivityEvent> processData(String inputName, Pattern pattern, boolean includeReadActivity) throws IOException {
        ArrayList<DatasetActivityEvent> events = new ArrayList<DatasetActivityEvent>();
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)inputName);){
            reader.include(15).include(17).include(18).include(61).include(62).include(64).include(65);
            if (includeReadActivity) {
                reader.include(14);
            }
            for (SmfRecord record : reader) {
                if ((record.recordType() == 14 || record.recordType() == 15) && Smf14Record.from((SmfRecord)record).smf14tds()) continue;
                DatasetActivityEvent event = DatasetActivityEvent.from(record);
                if (!includeReadActivity && event.isRead()) continue;
                if (pattern.matcher(event.getDatasetname()).matches()) {
                    events.add(event);
                    continue;
                }
                if (event.getNewname() == null || event.getNewname().length() <= 0 || !pattern.matcher(event.getNewname()).matches()) continue;
                events.add(event);
            }
        }
        return events;
    }

    private static void writeReport(List<DatasetActivityEvent> events) {
        Map<String, List<DatasetActivityEvent>> eventsByDataset = events.stream().collect(Collectors.groupingBy(DatasetActivityEvent::getDatasetname));
        eventsByDataset.keySet().stream().sorted().forEachOrdered(datasetName -> {
            System.out.format("%-44s %-25s %-8s %-8s %-15s %-44s%n", "Dataset", "Time", "Jobname", "Userid", "Activity", "New Name");
            ((List)eventsByDataset.get(datasetName)).stream().sorted(Comparator.comparing(DatasetActivityEvent::getTime)).forEachOrdered(event -> System.out.format("%-44s %-25s %-8s %-8s %-15s %-44s%n", event.getDatasetname(), event.getTime(), event.getJobname(), event.getUserid(), event.getEvent(), event.getNewname()));
            System.out.println();
        });
    }

    private static Pattern buildPattern(String patternString) {
        if (patternString.startsWith("\"") && patternString.endsWith("\"") || patternString.startsWith("'") && patternString.endsWith("'")) {
            patternString = patternString.substring(1, patternString.length() - 1);
        }
        patternString = patternString.replace(".", "\\.");
        patternString = patternString.replace("$", "\\$");
        patternString = patternString.replace("%", "[^.]");
        patternString = patternString.replace("**", ".%");
        patternString = patternString.replace("*", "[^.]%");
        patternString = patternString.replace("%", "*");
        return Pattern.compile("^" + patternString + "$", 66);
    }
}

