/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.r4ha;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf30.ProcessorAccountingSection;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import com.blackhillsoftware.smf.smf70.Smf70Record;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PeakR4HAJobs {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: PeakR4HAJobs <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<String, Map> systemHourLAC = new HashMap<String, Map>();
        HashMap<String, Map> systemHourJobnameTotals = new HashMap<String, Map>();
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]);){
            reader.include(70, 1).include(30, 2).include(30, 3);
            for (SmfRecord record : reader) {
                switch (record.recordType()) {
                    case 70: {
                        Smf70Record r70 = Smf70Record.from((SmfRecord)record);
                        String system = r70.system();
                        LocalDateTime hour = r70.smfDateTime().truncatedTo(ChronoUnit.HOURS);
                        systemHourLAC.computeIfAbsent(system, key -> new HashMap()).computeIfAbsent(hour, key -> new HourlyLac(system, hour)).add(r70);
                        break;
                    }
                    case 30: {
                        Smf30Record r30 = Smf30Record.from((SmfRecord)record);
                        String system = r30.system();
                        LocalDateTime hour = r30.smfDateTime().truncatedTo(ChronoUnit.HOURS);
                        String jobname = r30.identificationSection().smf30jbn();
                        systemHourJobnameTotals.computeIfAbsent(system, key -> new HashMap()).computeIfAbsent(hour, key -> new HashMap()).computeIfAbsent(jobname, key -> new JobnameTotals(jobname)).add(r30);
                        break;
                    }
                }
            }
        }
        List systems = systemHourLAC.keySet().stream().sorted().collect(Collectors.toList());
        for (String system : systems) {
            PeakR4HAJobs.writeReport(system, (Map)systemHourLAC.get(system), (Map)systemHourJobnameTotals.get(system));
        }
    }

    private static void writeReport(String system, Map<LocalDateTime, HourlyLac> hourlyLAC, Map<LocalDateTime, Map<String, JobnameTotals>> hourlyJobTotals) {
        System.out.format("%n%nSystem: %s%n", system);
        hourlyLAC.values().stream().sorted(Comparator.comparingLong(HourlyLac::hourAverageLAC).reversed()).limit(5L).forEachOrdered(hourEntry -> {
            LocalDateTime hour = hourEntry.getHour();
            long fourHourMSU = hourEntry.hourAverageLAC();
            System.out.format("%n    %-19s %21s%n", "Hour", "4H MSU");
            System.out.format("    %10s %8s %21d%n", hour.format(DateTimeFormatter.ISO_LOCAL_DATE), hour.format(DateTimeFormatter.ISO_LOCAL_TIME), fourHourMSU);
            ArrayList<JobnameTotals> fourHourJobs = new ArrayList<JobnameTotals>();
            for (int i = 0; i < 4; ++i) {
                if (!hourlyJobTotals.containsKey(hour.minusHours(i))) continue;
                fourHourJobs.addAll(((Map)hourlyJobTotals.get(hour.minusHours(i))).values());
            }
            double fourHourTotalCpTime = fourHourJobs.stream().collect(Collectors.summingDouble(JobnameTotals::getCpTime));
            PeakR4HAJobs.report4HourTopCpJobs(fourHourMSU, fourHourJobs, fourHourTotalCpTime);
            PeakR4HAJobs.report4HourTopZiipOnCpJobs(fourHourMSU, fourHourJobs, fourHourTotalCpTime);
        });
    }

    private static void report4HourTopCpJobs(long msuvalue, List<JobnameTotals> fourHourJobs, double fourHourTotalCpTime) {
        System.out.format("%n        %-12s %11s %12s%n", "Jobname", "CPU%", "Est. MSU");
        fourHourJobs.stream().collect(Collectors.groupingBy(JobnameTotals::getJobname, Collectors.summingDouble(JobnameTotals::getCpTime))).entrySet().stream().sorted((jobATotal, jobBTotal) -> ((Double)jobBTotal.getValue()).compareTo((Double)jobATotal.getValue())).limit(5L).forEachOrdered(jobCpTime -> System.out.format("        %-12s %10.1f%% %12.1f%n", jobCpTime.getKey(), (Double)jobCpTime.getValue() / (double)Duration.ofHours(4L).getSeconds() * 100.0, (Double)jobCpTime.getValue() / fourHourTotalCpTime * (double)msuvalue));
    }

    private static void report4HourTopZiipOnCpJobs(long msuvalue, List<JobnameTotals> fourHourJobs, double fourHourTotalCpTime) {
        System.out.format("%n%n        %-12s %11s %12s%n", "Jobname", "zIIP On CP%", "Est. MSU");
        fourHourJobs.stream().collect(Collectors.groupingBy(JobnameTotals::getJobname, Collectors.summingDouble(JobnameTotals::getZiipOnCpTime))).entrySet().stream().sorted((jobATotal, jobBTotal) -> ((Double)jobBTotal.getValue()).compareTo((Double)jobATotal.getValue())).limit(5L).forEachOrdered(jobCpTime -> System.out.format("        %-12s %10.1f%% %12.1f%n", jobCpTime.getKey(), (Double)jobCpTime.getValue() / (double)Duration.ofHours(4L).getSeconds() * 100.0, (Double)jobCpTime.getValue() / fourHourTotalCpTime * (double)msuvalue));
    }

    private static class HourlyLac {
        private String system;
        private LocalDateTime hour;
        private long smf70lac = 0L;
        private long smf70sam = 0L;

        public HourlyLac(String system, LocalDateTime hour) {
            this.system = system;
            this.hour = hour;
        }

        public String getSystem() {
            return this.system;
        }

        public LocalDateTime getHour() {
            return this.hour;
        }

        public void add(Smf70Record r70) {
            this.smf70lac += r70.cpuControlSection().smf70lac() * r70.productSection().smf70sam();
            this.smf70sam += r70.productSection().smf70sam();
        }

        public long hourAverageLAC() {
            return this.smf70sam > 0L ? this.smf70lac / this.smf70sam : 0L;
        }
    }

    private static class JobnameTotals {
        private double cpTime = 0.0;
        private double ziipOnCpTime = 0.0;
        private String jobname;

        public JobnameTotals(String jobname) {
            this.jobname = jobname;
        }

        public void add(Smf30Record r30) {
            if (!this.jobname.equals(r30.identificationSection().smf30jbn())) {
                throw new IllegalArgumentException("Wrong job name: " + r30.identificationSection().smf30jbn());
            }
            ProcessorAccountingSection pacct = r30.processorAccountingSection();
            if (pacct != null) {
                this.cpTime = this.cpTime + pacct.smf30cptSeconds() + pacct.smf30cpsSeconds() + pacct.smf30icuSeconds() + pacct.smf30isbSeconds() + pacct.smf30iipSeconds() + pacct.smf30rctSeconds() + pacct.smf30hptSeconds();
                this.ziipOnCpTime += pacct.smf30TimeZiipOnCpSeconds();
            }
        }

        public double getCpTime() {
            return this.cpTime;
        }

        public double getZiipOnCpTime() {
            return this.ziipOnCpTime;
        }

        public String getJobname() {
            return this.jobname;
        }
    }
}

