/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.rmf;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf70.Smf70Record;
import com.blackhillsoftware.smf.smf70.subtype1.CpuIdentificationSection;
import com.blackhillsoftware.smf.smf70.subtype1.PrismLogicalProcessorDataSection;
import com.blackhillsoftware.smf.smf70.subtype1.PrismPartitionDataSection;
import com.blackhillsoftware.smf.summary.Top;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CombinedLparMSU {
    private static Set<String> INCLUDESYSTEMS = new HashSet<String>(Arrays.asList(new String[0]));
    private static int INTERVAL = 60;
    private static int TOP_N = 20;

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: CombinedLparMSU <input-name> [<input-name> ...]");
            System.out.println("<input-name> can be filename or //'DATASET.NAME'");
            return;
        }
        HashMap<LocalDateTime, Interval> intervals = new HashMap<LocalDateTime, Interval>();
        HashSet<String> excludedSystems = new HashSet<String>();
        for (String input : args) {
            try (SmfRecordReader reader = SmfRecordReader.fromName((String)input).include(70, 1);){
                for (SmfRecord record : reader) {
                    if (INCLUDESYSTEMS.isEmpty() || INCLUDESYSTEMS.contains(record.system())) {
                        Smf70Record r70 = Smf70Record.from((SmfRecord)record);
                        LocalDateTime intervalTime = CombinedLparMSU.truncateTime(r70.productSection().smf70dat().atTime(r70.productSection().smf70ist()), INTERVAL);
                        intervals.computeIfAbsent(intervalTime, key -> new Interval()).add(r70);
                        continue;
                    }
                    excludedSystems.add(record.system());
                }
            }
        }
        CombinedLparMSU.writeReport(intervals, excludedSystems);
    }

    private static LocalDateTime truncateTime(LocalDateTime time, int interval) {
        int minutes = time.getMinute() / interval * interval;
        return time.truncatedTo(ChronoUnit.HOURS).plusMinutes(minutes);
    }

    private static void writeReport(Map<LocalDateTime, Interval> intervals, Set<String> excludedSystems) {
        System.out.format("%nTop %d intervals by LAC:%n", TOP_N);
        ((List)intervals.entrySet().stream().collect(Top.values((int)TOP_N, Comparator.comparingDouble(entry -> ((Interval)entry.getValue()).totalLac())))).forEach(entry -> CombinedLparMSU.printInterval(entry));
        System.out.format("%nTop %d intervals by MSU:%n", TOP_N);
        ((List)intervals.entrySet().stream().collect(Top.values((int)TOP_N, Comparator.comparingDouble(entry -> ((Interval)entry.getValue()).totalMsu())))).forEach(entry -> CombinedLparMSU.printInterval(entry));
        if (!excludedSystems.isEmpty()) {
            System.out.format("%nThe following systems were excluded:%n%s%n", excludedSystems.toString());
        }
    }

    private static void printInterval(Map.Entry<LocalDateTime, Interval> intervalEntry) {
        System.out.format("%n%-25s %7s %7s%n", intervalEntry.getKey(), "LAC", "MSU");
        intervalEntry.getValue().systems().stream().sorted(Map.Entry.comparingByKey()).forEach(system -> System.out.format("%-25s %7d %7.0f%n", system.getKey(), ((IntervalSystem)system.getValue()).lac(), ((IntervalSystem)system.getValue()).msu()));
        System.out.format("%n%-25s %7d %7.0f%n", "Total", intervalEntry.getValue().totalLac(), intervalEntry.getValue().totalMsu());
    }

    private static class Interval {
        private Map<String, IntervalSystem> systems = new HashMap<String, IntervalSystem>();

        private Interval() {
        }

        public void add(Smf70Record r70) {
            this.systems.computeIfAbsent(r70.system(), key -> new IntervalSystem()).add(r70);
        }

        public Set<Map.Entry<String, IntervalSystem>> systems() {
            return this.systems.entrySet();
        }

        public double totalMsu() {
            return this.systems.values().stream().collect(Collectors.summingDouble(IntervalSystem::msu));
        }

        public long totalLac() {
            return this.systems.values().stream().collect(Collectors.summingLong(IntervalSystem::lac));
        }
    }

    private static class IntervalSystem {
        private long maxLac = 0L;
        private double cumulativeMsu = 0.0;
        private Map<ZonedDateTime, Double> rmfIntervals = new HashMap<ZonedDateTime, Double>();

        private IntervalSystem() {
        }

        public void add(Smf70Record r70) {
            this.maxLac = Math.max(this.maxLac, r70.cpuControlSection().smf70lac());
            this.rmfIntervals.put(r70.productSection().smf70iet(), r70.productSection().smf70intSeconds());
            PrismPartitionDataSection myPartition = r70.prismPartitionDataSections().stream().filter(x -> x.smf70lpn() == r70.productSection().smf70ptn() || r70.prismPartitionDataSections().size() == 2 && !x.smf70lpm().equals("PHYSICAL") && ((PrismPartitionDataSection)r70.prismPartitionDataSections().get(1)).smf70lpm().equals("PHYSICAL")).findFirst().orElse(null);
            if (myPartition != null) {
                List processors = r70.prismLogicalProcessorDataSections();
                for (int i = (int)myPartition.smf70bds(); i < myPartition.smf70bdn(); ++i) {
                    if (!((CpuIdentificationSection)r70.cpuIdentificationSections().get(((PrismLogicalProcessorDataSection)processors.get(i)).smf70cix() - 1)).smf70cin().equals("CP")) continue;
                    this.cumulativeMsu += ((PrismLogicalProcessorDataSection)processors.get(i)).smf70edtSeconds() * 16.0 / ((double)r70.cpuControlSection().smf70cpaActual() / (double)r70.cpuControlSection().smf70cpaScalingFactor());
                }
            }
        }

        public long lac() {
            return this.maxLac;
        }

        public double msu() {
            double totalseconds = 0.0;
            for (Double seconds : this.rmfIntervals.values()) {
                totalseconds += seconds.doubleValue();
            }
            return this.cumulativeMsu / totalseconds * 3600.0;
        }
    }
}

