/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.type30;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf30.ProcessorAccountingSection;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import java.io.IOException;
import java.time.Duration;

public class CpuGt60 {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: CpuGt60 <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]);){
            reader.include(30, 5);
            for (SmfRecord record : reader) {
                Smf30Record r30 = Smf30Record.from((SmfRecord)record);
                for (ProcessorAccountingSection procAcct : r30.processorAccountingSections()) {
                    Duration cpuTime = procAcct.smf30cpt().plus(procAcct.smf30cps());
                    if (cpuTime.getSeconds() < 60L) continue;
                    System.out.format("%-23s %-8s %12s%n", r30.smfDateTime(), r30.identificationSection().smf30jbn(), cpuTime);
                }
            }
        }
        System.out.println("Done");
    }
}

