/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.type30;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JobsByJobname {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: JobsByJobname <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<String, JobData> jobs = new HashMap<String, JobData>();
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]);){
            reader.include(30, 5);
            for (SmfRecord record : reader) {
                Smf30Record r30 = Smf30Record.from((SmfRecord)record);
                JobData jobentry = jobs.computeIfAbsent(r30.identificationSection().smf30jbn(), x -> new JobData());
                jobentry.accumulateData(r30);
            }
        }
        JobsByJobname.writeReport(jobs);
    }

    private static void writeReport(Map<String, JobData> jobs) {
        System.out.format("%n%-8s %6s %14s %14s %14s %14s %14s %14s %14s %14s%n", "Jobname", "Count", "CPU", "zIIP", "Connect", "Excp", "Avg CPU", "Avg zIIP", "Avg Connect", "Avg Excp");
        jobs.entrySet().stream().filter(entry -> ((JobData)entry.getValue()).count > 0).sorted((a, b) -> Double.compare(((JobData)b.getValue()).cpTime, ((JobData)a.getValue()).cpTime)).limit(100L).forEachOrdered(entry -> {
            String jobname = (String)entry.getKey();
            JobData jobinfo = (JobData)entry.getValue();
            System.out.format("%-8s %,6d %14s %14s %14s %,14d %14s %14s %14s %,14d%n", jobname, jobinfo.count, JobsByJobname.hhhmmss(jobinfo.cpTime), JobsByJobname.hhhmmss(jobinfo.ziipTime), JobsByJobname.hhhmmss(jobinfo.connectTime), jobinfo.excps, JobsByJobname.hhhmmss(jobinfo.cpTime / (double)jobinfo.count), JobsByJobname.hhhmmss(jobinfo.ziipTime / (double)jobinfo.count), JobsByJobname.hhhmmss(jobinfo.connectTime / (double)jobinfo.count), jobinfo.excps / (long)jobinfo.count);
        });
    }

    private static String hhhmmss(double totalseconds) {
        int SECONDS_PER_MINUTE = 60;
        int SECONDS_PER_HOUR = 3600;
        int hours = (int)(totalseconds / 3600.0);
        int minutes = (int)(totalseconds % 3600.0) / 60;
        double seconds = totalseconds % 60.0;
        return String.format("%d:%02d:%05.2f", hours, minutes, seconds);
    }

    private static class JobData {
        int count = 0;
        double cpTime = 0.0;
        double ziipTime = 0.0;
        double connectTime = 0.0;
        long excps = 0L;

        private JobData() {
        }

        public void accumulateData(Smf30Record r30) {
            if (r30.processorAccountingSection() != null) {
                ++this.count;
                this.cpTime += r30.processorAccountingSection().smf30cptSeconds() + r30.processorAccountingSection().smf30cpsSeconds();
                this.ziipTime += r30.processorAccountingSection().smf30TimeOnZiipSeconds();
            }
            if (r30.ioActivitySection() != null) {
                this.excps += r30.ioActivitySection().smf30tex();
                this.connectTime += r30.ioActivitySection().smf30aicSeconds();
            }
        }
    }
}

