/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.type30;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf30.ProcessorAccountingSection;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import java.io.IOException;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrimeShiftTopJobs {
    static final List<DayOfWeek> primeDays = Arrays.asList(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    static final LocalTime primeStartTime = LocalTime.of(8, 30);
    static final LocalTime primeEndTime = LocalTime.of(17, 30);

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: PrimeShiftTopJobs <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<DayOfWeek, HashMap<String, JobData>> jobsByDay = new HashMap<DayOfWeek, HashMap<String, JobData>>();
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]);){
            reader.include(30, 2).include(30, 3).stream().filter(record -> primeDays.contains(record.smfDate().getDayOfWeek()) && record.smfTime().isAfter(primeStartTime) && record.smfTime().isBefore(primeEndTime)).map(record -> Smf30Record.from((SmfRecord)record)).forEach(r30 -> jobsByDay.computeIfAbsent(r30.smfDate().getDayOfWeek(), day -> new HashMap()).computeIfAbsent(r30.identificationSection().smf30jbn(), job -> new JobData()).add((Smf30Record)r30));
        }
        PrimeShiftTopJobs.writeReport(jobsByDay);
    }

    private static void writeReport(Map<DayOfWeek, HashMap<String, JobData>> dailyJobs) {
        dailyJobs.entrySet().stream().sorted((a, b) -> ((DayOfWeek)a.getKey()).compareTo((DayOfWeek)b.getKey())).forEachOrdered(day -> {
            double totalDayCp = ((HashMap)day.getValue()).entrySet().stream().mapToDouble(job -> ((JobData)job.getValue()).cpTime).sum();
            System.out.format("%n%s%n", ((DayOfWeek)day.getKey()).toString());
            System.out.format("%-8s %11s %5s %11s%n", "Name", "CPU", "CPU%", "zIIP");
            ((HashMap)day.getValue()).entrySet().stream().sorted((a, b) -> Double.compare(((JobData)b.getValue()).cpTime, ((JobData)a.getValue()).cpTime)).limit(10L).forEachOrdered(entry -> {
                JobData jobinfo = (JobData)entry.getValue();
                System.out.format("%-8s %11s %4.0f%% %11s%n", entry.getKey(), PrimeShiftTopJobs.hhhmmss(jobinfo.cpTime), jobinfo.cpTime / totalDayCp * 100.0, PrimeShiftTopJobs.hhhmmss(jobinfo.ziipTime));
            });
        });
    }

    private static String hhhmmss(double totalseconds) {
        int SECONDS_PER_MINUTE = 60;
        int SECONDS_PER_HOUR = 3600;
        int hours = (int)(totalseconds / 3600.0);
        int minutes = (int)(totalseconds % 3600.0) / 60;
        double seconds = totalseconds % 60.0;
        return String.format("%d:%02d:%05.2f", hours, minutes, seconds);
    }

    private static class JobData {
        double cpTime = 0.0;
        double ziipTime = 0.0;

        private JobData() {
        }

        public void add(Smf30Record r30) {
            ProcessorAccountingSection procAcct = r30.processorAccountingSection();
            if (procAcct != null) {
                this.cpTime += procAcct.smf30cptSeconds() + procAcct.smf30cpsSeconds();
                this.ziipTime += procAcct.smf30TimeOnZiipSeconds();
            }
        }
    }
}

